/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ajax.ReqestDispatcher;
import org.ujorm.tools.web.ao.Column;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;
import org.ujorm.tools.web.ao.WebUtils;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.web.table.TableBuilderConfig;
import org.ujorm.tools.web.table.TableBuilderConfigImpl;
import org.ujorm.tools.xml.config.HtmlConfig;

public class TableBuilder<D> {
    private static final Logger LOGGER = Logger.getLogger(TableBuilder.class.getName());
    protected final List<ColumnModel<D, ?>> columns = new ArrayList();
    protected final Stream<D> resource;
    protected final TableBuilderConfig config;
    protected HttpParameter ajaxRequestParam = JavaScriptWriter.DEFAULT_AJAX_REQUEST_PARAM;
    @Nonnull
    protected Injector header = e -> e.addHeading(this.config.getConfig().getTitle(), new CharSequence[0]);
    @Nonnull
    protected Injector footer;
    @Nonnull
    protected Injector formAdditions = this.footer = e -> e.addText((Object)"");
    @Nonnull
    protected Injector inlineCss = this.inlineCssWriter();
    @Nonnull
    protected Supplier<Injector> javascritWriter = () -> new JavaScriptWriter().setSubtitleSelector("." + this.config.getSubtitleCss());
    protected boolean ajaxEnabled = true;
    protected boolean autoSubmmitOnLoad = false;

    private TableBuilder(@Nonnull Stream<D> resource, @Nonnull TableBuilderConfig config) {
        this.resource = resource;
        this.config = config;
    }

    @Nonnull
    public static <D> TableBuilder<D> of(@Nonnull Stream<D> resource) {
        return TableBuilder.of("Info", resource);
    }

    @Nonnull
    public static <D> TableBuilder<D> of(@Nonnull String title, @Nonnull Stream<D> resource) {
        return TableBuilder.of(resource, (HtmlConfig)HtmlConfig.ofDefault().setTitle((CharSequence)title).setNiceFormat());
    }

    @Nonnull
    public static <D> TableBuilder<D> of(@Nonnull Stream<D> resource, @Nonnull HtmlConfig config) {
        return new TableBuilder<D>(resource, new TableBuilderConfigImpl(config));
    }

    @Nonnull
    public static <D> TableBuilder<D> of(@Nonnull Stream<D> resource, @Nonnull TableBuilderConfig config) {
        return new TableBuilder<D>(resource, config);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column) {
        return this.addInternal(column, "Column-" + (this.columns.size() + 1), null);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, CharSequence title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, Injector title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, CharSequence title, @Nullable HttpParameter param) {
        return this.addInternal(column, title, param);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, Injector title, @Nullable HttpParameter param) {
        return this.addInternal(column, title, param);
    }

    @Nonnull
    public <V> TableBuilder<D> addToElement(Column<D> column, CharSequence title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> TableBuilder<D> addToElement(Column<D> column, Injector title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    protected <V> TableBuilder<D> addInternal(@Nonnull Function<D, ?> column, @Nonnull CharSequence title, @Nullable HttpParameter param) {
        this.columns.add(new ColumnModel(column, title, param));
        return this;
    }

    @Nonnull
    public TableBuilder<D> setAjaxRequestParam(@Nonnull HttpParameter ajaxRequestParam) {
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        return this;
    }

    @Nonnull
    public TableBuilder<D> setHeader(@Nonnull Injector header) {
        this.header = (Injector)Assert.notNull((Object)header, (Object[])new String[]{"header"});
        return this;
    }

    @Nonnull
    public TableBuilder<D> setFooter(@Nonnull Injector footer) {
        this.footer = (Injector)Assert.notNull((Object)footer, (Object[])new String[]{"footer"});
        return this;
    }

    @Nonnull
    public TableBuilder<D> setFormAdditions(@Nonnull Injector formAdditions) {
        this.formAdditions = (Injector)Assert.notNull((Object)formAdditions, (Object[])new String[]{"formAdditions"});
        return this;
    }

    public TableBuilder<D> setAjaxEnabled(boolean ajaxEnabled) {
        this.ajaxEnabled = ajaxEnabled;
        return this;
    }

    public TableBuilder<D> setJavascritWriter(@Nonnull Supplier<Injector> javascritWriter) {
        this.javascritWriter = (Supplier)Assert.notNull(javascritWriter, (Object[])new String[]{"javascritWriter"});
        return this;
    }

    public void build(HttpServletRequest input, HttpServletResponse output) {
        try {
            new ReqestDispatcher(input, output, this.config.getConfig()).onParam(this.config.getAjaxRequestParam(), jsonBuilder -> this.doAjax(input, (JsonBuilder)jsonBuilder)).onDefaultToElement(element -> this.printHtmlBody(input, element));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Internal server error", e);
            output.setStatus(500);
        }
    }

    protected void printHtmlBody(HttpServletRequest input, HtmlElement html) {
        html.addJavascriptLink(false, this.config.getJqueryLink());
        html.addCssLink(this.config.getCssLink());
        this.inlineCss.write(html.getHead());
        if (this.ajaxEnabled) {
            this.javascritWriter.get().write(html.getHead());
        }
        try (Element body = html.getBody();){
            this.header.write(body);
            body.addDiv(this.config.getSubtitleCss()).addText((Object)(this.ajaxEnabled ? this.config.getAjaxReadyMessage() : ""));
            try (Element form = body.addForm(new CharSequence[0]).setId(this.config.getFormId()).setMethod("post").setAction("?");){
                for (ColumnModel<D, ?> column : this.columns) {
                    if (!column.isFiltered()) continue;
                    form.addInput(this.config.getControlCss(), column.param).setName(column.param).setValue(column.param.of((ServletRequest)input, "")).setAttribute("placeholder", column.title);
                }
                form.addInput(new CharSequence[0]).setType("submit").setAttrib("hidden", "");
                this.formAdditions.write(form);
            }
            List<CharSequence> tableCss = this.config.getTableCssClass();
            this.printTableBody(body.addTable(tableCss.toArray(new CharSequence[tableCss.size()])), input);
            this.footer.write(body);
        }
    }

    protected void printTableBody(Element table, HttpServletRequest input) {
        Element headerElement = table.addElement("thead").addElement("tr");
        for (ColumnModel<D, ?> col : this.columns) {
            CharSequence value2 = col.title;
            Element th = headerElement.addElement("th");
            if (value2 instanceof Injector) {
                ((Injector)value2).write(th);
                continue;
            }
            th.addText((Object)value2);
        }
        try (Element tBody = table.addElement("tbody");){
            boolean hasRenderer = WebUtils.isType(Column.class, this.columns.stream().map(t -> t.column));
            this.resource.forEach(value -> {
                Element rowElement = tBody.addElement("tr");
                for (ColumnModel<D, ?> col : this.columns) {
                    Function attribute = col.column;
                    Element td = rowElement.addElement("td");
                    if (hasRenderer && attribute instanceof Column) {
                        ((Column)attribute).write(td, value);
                        continue;
                    }
                    td.addText(attribute.apply(value));
                }
            });
        }
    }

    protected void doAjax(HttpServletRequest input, JsonBuilder output) throws ServletException, IOException {
        output.writeClass(this.config.getTableSelector(), e -> this.printTableBody(e, input));
        output.writeClass((CharSequence)this.config.getSubtitleCss(), this.config.getAjaxReadyMessage());
    }

    @Nonnull
    protected Injector inlineCssWriter() {
        return element -> {
            TableBuilderConfig conf = this.config;
            CharSequence newLine = conf.getConfig().getNewLine();
            try (Element css = element.addElement("style");){
                css.addRawText(newLine, "body { margin: 10px;}");
                css.addRawText(newLine, ".", conf.getSubtitleCss(), " { font-size: 10px; color: silver;}");
                css.addRawText(newLine, "#", conf.getFormId(), " { margin-bottom: 2px;}");
                css.addRawText(newLine, "#", conf.getFormId(), " input { width: 200px;}");
                css.addRawText(newLine, ".", conf.getControlCss(), " { display: inline;}");
                css.addRawText(newLine, ".table th { background-color: #e8e8e8;}");
            }
        };
    }

    public static class Url {
        protected static final String BOOTSTRAP_CSS = "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css";
        protected static final String JQUERY_JS = "https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js";
        final String bootstrapCss;
        final String jQueryJs;

        public Url() {
            this(BOOTSTRAP_CSS, JQUERY_JS);
        }

        public Url(@Nonnull String bootstrapCss, @Nonnull String jQueryJs) {
            this.bootstrapCss = (String)Assert.hasLength((CharSequence)bootstrapCss, (Object[])new String[]{"bootstrapCss"});
            this.jQueryJs = (String)Assert.hasLength((CharSequence)jQueryJs, (Object[])new String[]{"jQueryJs"});
        }
    }

    class ColumnModel<D, V> {
        @Nonnull
        final Function<D, V> column;
        @Nonnull
        final CharSequence title;
        @Nullable
        final HttpParameter param;

        public ColumnModel(@Nonnull Function<D, V> column, @Nonnull CharSequence title, HttpParameter param) {
            this.column = column;
            this.title = title;
            this.param = param;
        }

        public boolean isFiltered() {
            return this.param != null;
        }
    }
}

