/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.table.TableBuilderConfig;
import org.ujorm.tools.xml.config.HtmlConfig;

public class TableBuilderConfigImpl<D>
implements TableBuilderConfig<D> {
    private static final Logger LOGGER = Logger.getLogger(TableBuilderConfigImpl.class.getName());
    @Nonnull
    protected final HtmlConfig config;
    @Nonnull
    private String cssLink;
    @Nonnull
    private String jqueryLink;
    @Nonnull
    private Duration idleDelay;
    @Nonnull
    private HttpParameter ajaxRequestParam;
    @Nonnull
    private CharSequence ajaxReadyMessage = "AJAX ready";
    @Nonnull
    private String formId;
    @Nonnull
    private String controlCss;
    @Nonnull
    private String subtitleCss;
    @Nonnull
    private CharSequence tableSelector;
    @Nonnull
    private List<CharSequence> tableCssClass;

    public TableBuilderConfigImpl(@Nonnull HtmlConfig config) {
        this(config, "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css", "https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js", Constants.IDLE_DELAY, JavaScriptWriter.DEFAULT_AJAX_REQUEST_PARAM, "form", "form-control", "subtitle", Constants.TABLE_CSS_CLASS);
    }

    public TableBuilderConfigImpl(@Nonnull HtmlConfig config, @Nonnull String cssLink, @Nonnull String jqueryLink, @Nonnull Duration idleDelay, @Nonnull HttpParameter ajaxRequestParam, @Nonnull String formId, @Nonnull String controlCss, @Nonnull String subtitleCss, @Nonnull List<CharSequence> tableCssClass) {
        this.config = config;
        this.cssLink = cssLink;
        this.jqueryLink = jqueryLink;
        this.idleDelay = idleDelay;
        this.formId = formId;
        this.controlCss = controlCss;
        this.subtitleCss = subtitleCss;
        this.tableCssClass = tableCssClass;
        this.ajaxRequestParam = ajaxRequestParam;
    }

    @Nonnull
    protected CharSequence getTableClassSelector() {
        return this.tableCssClass.isEmpty() ? "table" : String.join((CharSequence)" .", "table", this.tableCssClass.get(0));
    }

    public TableBuilderConfigImpl<D> setCssLink(@Nonnull String cssLink) {
        this.cssLink = (String)Assert.notNull((Object)cssLink, (Object[])new String[]{"cssLink"});
        return this;
    }

    public TableBuilderConfigImpl<D> setJqueryLink(@Nonnull String jqueryLink) {
        this.jqueryLink = (String)Assert.notNull((Object)jqueryLink, (Object[])new String[]{"jqueryLink"});
        return this;
    }

    public TableBuilderConfigImpl<D> setIdleDelay(@Nonnull Duration idleDelay) {
        this.idleDelay = (Duration)Assert.notNull((Object)idleDelay, (Object[])new String[]{"idleDelay"});
        return this;
    }

    public TableBuilderConfigImpl<D> setAjaxRequestParam(@Nonnull HttpParameter ajaxRequestParam) {
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        return this;
    }

    public TableBuilderConfigImpl<D> setAjaxReadyMessage(@Nonnull CharSequence ajaxReadyMessage) {
        this.ajaxReadyMessage = Assert.hasLength((CharSequence)ajaxReadyMessage, (Object[])new String[]{"ajaxReadyMessage"});
        return this;
    }

    public TableBuilderConfigImpl<D> setFormId(@Nonnull String formId) {
        this.formId = (String)Assert.hasLength((CharSequence)formId, (Object[])new String[]{"formId"});
        return this;
    }

    public TableBuilderConfigImpl<D> setControlCss(@Nonnull String controlCss) {
        this.controlCss = (String)Assert.hasLength((CharSequence)controlCss, (Object[])new String[]{"controlCss"});
        return this;
    }

    public TableBuilderConfigImpl<D> setSubtitleCss(@Nonnull String subtitleCss) {
        this.subtitleCss = (String)Assert.hasLength((CharSequence)subtitleCss, (Object[])new String[]{"subtitleCss"});
        return this;
    }

    public TableBuilderConfigImpl<D> setTableSelector(@Nonnull CharSequence tableSelector) {
        this.tableSelector = (CharSequence)Assert.notNull((Object)tableSelector, (Object[])new String[]{"tableSelector"});
        return this;
    }

    public TableBuilderConfigImpl<D> setTableCssClass(@Nonnull List<CharSequence> tableCssClass) {
        this.tableCssClass = (List)Assert.notNull(tableCssClass, (Object[])new String[]{"tableCssClass"});
        return this;
    }

    @Override
    @Nonnull
    public HtmlConfig getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public String getCssLink() {
        return this.cssLink;
    }

    @Override
    @Nonnull
    public String getJqueryLink() {
        return this.jqueryLink;
    }

    @Override
    @Nonnull
    public Duration getIdleDelay() {
        return this.idleDelay;
    }

    @Override
    @Nonnull
    public HttpParameter getAjaxRequestParam() {
        return this.ajaxRequestParam;
    }

    @Override
    public CharSequence getAjaxReadyMessage() {
        return this.ajaxReadyMessage;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public String getControlCss() {
        return this.controlCss;
    }

    @Override
    public String getSubtitleCss() {
        return this.subtitleCss;
    }

    @Override
    public CharSequence getTableSelector() {
        return this.tableSelector != null ? this.tableSelector : this.getTableCssClass().get(0);
    }

    @Override
    public List<CharSequence> getTableCssClass() {
        return this.tableCssClass;
    }

    public static class Constants {
        protected static final String BOOTSTRAP_CSS = "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css";
        protected static final String JQUERY_JS = "https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js";
        public static final String FORM_ID = "form";
        public static final String CONTROL_CSS = "form-control";
        public static final String SUBTITLE_CSS = "subtitle";
        public static List<CharSequence> TABLE_CSS_CLASS = Arrays.asList("table", "table-striped", "table-bordered");
        public static final Duration IDLE_DELAY = Duration.ofMillis(250L);
    }
}

