/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.IOConsumer;
import org.ujorm.tools.web.ao.IOElement;
import org.ujorm.tools.web.ao.IORunnable;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.xml.config.HtmlConfig;

public class ReqestDispatcher {
    private static final Logger LOGGER = Logger.getLogger(ReqestDispatcher.class.getName());
    @Nonnull
    private final HttpServletRequest input;
    @Nonnull
    private final HttpServletResponse output;
    @Nonnull
    private HtmlConfig htmlConfig;
    private boolean done = false;
    private final boolean noCache = true;

    public ReqestDispatcher(@Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output) {
        this("Info", input, output);
    }

    public ReqestDispatcher(@Nonnull CharSequence title, @Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output) {
        this(input, output, (HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public ReqestDispatcher(@Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output, @Nonnull HtmlConfig htmlConfig) {
        this.input = input;
        this.output = output;
        this.htmlConfig = htmlConfig;
        try {
            String charset = htmlConfig.getCharset().toString();
            input.setCharacterEncoding(charset);
            output.setCharacterEncoding(charset);
            output.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            output.setHeader("Pragma", "no-cache");
            output.setHeader("Expires", "0");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    public HtmlConfig getAjaxConfig() {
        return this.htmlConfig.cloneForAjax();
    }

    public ReqestDispatcher onParam(@Nonnull HttpParameter key, @Nonnull IOConsumer<JsonBuilder> processor) throws IOException, ServletException {
        Assert.notNull((Object)key, (Object[])new String[]{"Parameter {} is required", "key"});
        if (!this.done && key.isTrue((ServletRequest)this.input)) {
            try (JsonBuilder builder = JsonBuilder.of(this.input, this.output, this.getAjaxConfig());){
                this.done = true;
                processor.accept(builder);
            }
        }
        return this;
    }

    public void onDefaultToElement(@Nonnull IOElement defaultProcessor) throws ServletException, IOException {
        if (!this.done) {
            try (HtmlElement html = HtmlElement.of(this.htmlConfig, this.output.getWriter());){
                defaultProcessor.run(html);
            }
        }
    }

    public void onDefault(@Nonnull IORunnable defaultProcessor) throws ServletException, IOException {
        if (!this.done) {
            defaultProcessor.run();
        }
    }
}

