/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ajax.ReqestDispatcher;
import org.ujorm.tools.web.ao.Column;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;
import org.ujorm.tools.web.ao.WebUtils;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.web.table.ColumnModel;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.TableBuilderConfig;
import org.ujorm.tools.web.table.TableBuilderConfigImpl;
import org.ujorm.tools.xml.config.HtmlConfig;

public class TableBuilder<D> {
    private static final Logger LOGGER = Logger.getLogger(TableBuilder.class.getName());
    protected final List<ColumnModel<D, ?>> columns = new ArrayList();
    protected final TableBuilderConfig config;
    protected HttpParameter ajaxRequestParam = JavaScriptWriter.DEFAULT_AJAX_REQUEST_PARAM;
    @Nonnull
    protected Injector header = e -> e.addHeading(this.config.getConfig().getTitle(), new CharSequence[0]);
    @Nonnull
    protected Injector footer;
    @Nonnull
    protected Injector formAdditions = this.footer = e -> e.addText((Object)"");
    @Nonnull
    protected Supplier<Injector> javascritWriter = () -> new JavaScriptWriter().setSortable(this.isSortable()).setSubtitleSelector("." + this.config.getSubtitleCss());
    protected boolean ajaxEnabled = true;
    protected boolean autoSubmmitOnLoad = false;
    @Nullable
    private int sortedColumn = -1;

    public TableBuilder(@Nonnull CharSequence title) {
        this((HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public TableBuilder(@Nonnull HtmlConfig config) {
        this(TableBuilderConfig.of(config));
    }

    public TableBuilder(@Nonnull TableBuilderConfig config) {
        this.config = config;
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column) {
        return this.addInternal(column, "Column-" + (this.columns.size() + 1), null);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, CharSequence title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, Injector title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, CharSequence title, @Nullable HttpParameter param) {
        return this.addInternal(column, title, param);
    }

    @Nonnull
    public <V> TableBuilder<D> add(Function<D, ?> column, Injector title, @Nullable HttpParameter param) {
        return this.addInternal(column, title, param);
    }

    @Nonnull
    public <V> TableBuilder<D> addToElement(Column<D> column, CharSequence title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> TableBuilder<D> addToElement(Column<D> column, Injector title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    protected <V> TableBuilder<D> addInternal(@Nonnull Function<D, ?> column, @Nonnull CharSequence title, @Nullable HttpParameter param) {
        this.columns.add(new ColumnModel(this.columns.size(), column, title, param));
        return this;
    }

    public ColumnModel<D, ?> getColumn(int index) {
        return this.columns.get(index);
    }

    public int getColumnSize() {
        return this.columns.size();
    }

    @Nonnull
    public <V> TableBuilder<D> sortable() {
        return this.sortable(Direction.NONE);
    }

    @Nonnull
    public <V> TableBuilder<D> sortable(@Nullable boolean ascending) {
        return this.sortable(ascending ? Direction.ASC : Direction.DESC);
    }

    @Nonnull
    public <V> TableBuilder<D> sortable(@Nonnull Direction direction) {
        Assert.notNull((Object)((Object)direction), (Object[])new String[]{"direction"});
        Assert.hasLength(this.columns, (Object[])new String[]{"No column is available"});
        this.columns.get(this.columns.size() - 1).setSortable(direction);
        return this;
    }

    @Nonnull
    public ColumnModel<D, ?> getSortedColumn() {
        return this.sortedColumn >= 0 && this.sortedColumn < this.getColumnSize() ? this.getColumn(this.sortedColumn) : ColumnModel.ofStub();
    }

    @Nonnull
    public TableBuilder<D> setAjaxRequestParam(@Nonnull HttpParameter ajaxRequestParam) {
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        return this;
    }

    @Nonnull
    public TableBuilder<D> setHeader(@Nonnull Injector header) {
        this.header = (Injector)Assert.notNull((Object)header, (Object[])new String[]{"header"});
        return this;
    }

    @Nonnull
    public TableBuilder<D> setFooter(@Nonnull Injector footer) {
        this.footer = (Injector)Assert.notNull((Object)footer, (Object[])new String[]{"footer"});
        return this;
    }

    @Nonnull
    public TableBuilder<D> setFormAdditions(@Nonnull Injector formAdditions) {
        this.formAdditions = (Injector)Assert.notNull((Object)formAdditions, (Object[])new String[]{"formAdditions"});
        return this;
    }

    public TableBuilder<D> setAjaxEnabled(boolean ajaxEnabled) {
        this.ajaxEnabled = ajaxEnabled;
        return this;
    }

    public TableBuilder<D> setJavascritWriter(@Nonnull Supplier<Injector> javascritWriter) {
        this.javascritWriter = (Supplier)Assert.notNull(javascritWriter, (Object[])new String[]{"javascritWriter"});
        return this;
    }

    public TableBuilder<D> setEmbeddedIcons(boolean embeddedIcons) throws IllegalStateException {
        if (!(this.config instanceof TableBuilderConfigImpl)) {
            throw new IllegalStateException("Configuration must be type of: " + TableBuilderConfigImpl.class);
        }
        ((TableBuilderConfigImpl)this.config).setEmbeddedIcons(embeddedIcons);
        return this;
    }

    public void build(@Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output, @Nonnull Stream<D> resource) {
        this.build(input, output, (TableBuilder<D> tableBuilder) -> resource);
    }

    public void build(@Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output, @Nonnull Function<TableBuilder<D>, Stream<D>> resource) {
        try {
            this.setSort(ColumnModel.ofCode(this.config.getSortRequestParam().of((ServletRequest)input)));
            new ReqestDispatcher(input, output, this.config.getConfig()).onParam(this.config.getAjaxRequestParam(), jsonBuilder -> this.doAjax(input, (JsonBuilder)jsonBuilder, resource)).onDefaultToElement(element -> this.printHtmlBody(input, element, resource));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Internal server error", e);
            output.setStatus(500);
        }
    }

    protected void setSort(@Nonnull ColumnModel sort) {
        this.sortedColumn = sort.getIndex();
        if (this.sortedColumn >= 0) {
            int max = this.columns.size();
            for (int i = 0; i < max; ++i) {
                ColumnModel<D, ?> cm = this.columns.get(i);
                if (!cm.isSortable()) continue;
                cm.setDirection(sort.getIndex() == i ? sort.getDirection() : Direction.NONE);
            }
        }
    }

    protected void printHtmlBody(@Nonnull HttpServletRequest input, @Nonnull HtmlElement html, @Nonnull Function<TableBuilder<D>, Stream<D>> resource) {
        Assert.notNull((Object)input, (Object[])new String[]{"input"});
        Assert.notNull((Object)html, (Object[])new String[]{"html"});
        Assert.notNull(resource, (Object[])new String[]{"resource"});
        html.addJavascriptLink(false, this.config.getJqueryLink());
        html.addCssLink(this.config.getCssLink());
        this.config.getCssWriter().accept(html.getHead(), this.isSortable());
        if (this.ajaxEnabled) {
            this.javascritWriter.get().write(html.getHead());
        }
        try (Element body = html.getBody();){
            this.header.write(body);
            body.addDiv(this.config.getSubtitleCss()).addText((Object)(this.ajaxEnabled ? this.config.getAjaxReadyMessage() : ""));
            try (Element form = body.addForm(new CharSequence[0]).setId(this.config.getFormId()).setMethod("post").setAction("?");){
                for (ColumnModel<D, ?> column : this.columns) {
                    if (!column.isFiltered()) continue;
                    form.addInput(this.config.getControlCss(), column.getParam()).setName(column.getParam()).setValue(column.getParam().of((ServletRequest)input, "")).setAttribute("placeholder", column.getTitle());
                }
                if (this.isSortable()) {
                    form.addInput(new CharSequence[0]).setAttribute("type", "hidden").setName(this.config.getSortRequestParam()).setValue(this.config.getSortRequestParam().of((ServletRequest)input));
                }
                form.addInput(new CharSequence[0]).setType("submit").setAttribute("hidden");
                this.formAdditions.write(form);
            }
            List<CharSequence> tableCss = this.config.getTableCssClass();
            this.printTableBody(body.addTable(tableCss.toArray(new CharSequence[tableCss.size()])), input, resource);
            this.footer.write(body);
        }
    }

    protected void printTableBody(@Nonnull Element table, @Nonnull HttpServletRequest input, @Nonnull Function<TableBuilder<D>, Stream<D>> resource) {
        Element headerElement = table.addElement("thead").addElement("tr");
        for (ColumnModel<D, ?> col : this.columns) {
            InputStream img;
            Element thLink;
            CharSequence value2 = col.getTitle();
            Element th = headerElement.addElement("th");
            Element element = thLink = col.isSortable() ? th.addAnchor("javascript:sort(" + col.toCode(true) + ")", new CharSequence[0]) : th;
            if (col.isSortable()) {
                thLink.setClass(this.config.getSortable(), this.config.getSortableDirection(col.getDirection()));
            }
            if (value2 instanceof Injector) {
                ((Injector)value2).write(thLink);
            } else {
                thLink.addText((Object)value2);
            }
            if (!col.isSortable() || !this.config.isEmbeddedIcons() || (img = this.config.getInnerSortableImageToStream(col.getDirection())) == null) continue;
            thLink.addImage(img, (CharSequence)col.getDirection().toString(), new CharSequence[0]);
        }
        try (Element tBody = table.addElement("tbody");){
            boolean hasRenderer = WebUtils.isType(Column.class, this.columns.stream().map(t -> t.getColumn()));
            resource.apply(this).forEach(value -> {
                Element rowElement = tBody.addElement("tr");
                for (ColumnModel<D, ?> col : this.columns) {
                    Function<D, ?> attribute = col.getColumn();
                    Element td = rowElement.addElement("td");
                    if (hasRenderer && attribute instanceof Column) {
                        ((Column)attribute).write(td, value);
                        continue;
                    }
                    td.addText(attribute.apply(value));
                }
            });
        }
    }

    protected void doAjax(@Nonnull HttpServletRequest input, @Nonnull JsonBuilder output, @Nonnull Function<TableBuilder<D>, Stream<D>> resource) throws ServletException, IOException {
        output.writeClass(this.config.getTableSelector(), e -> this.printTableBody(e, input, resource));
        output.writeClass((CharSequence)this.config.getSubtitleCss(), this.config.getAjaxReadyMessage());
    }

    protected boolean isSortable() {
        for (ColumnModel<D, ?> column : this.columns) {
            if (!column.isSortable()) continue;
            return true;
        }
        return false;
    }

    public static class Url {
        protected static final String BOOTSTRAP_CSS = "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css";
        protected static final String JQUERY_JS = "https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js";
        final String bootstrapCss;
        final String jQueryJs;

        public Url() {
            this(BOOTSTRAP_CSS, JQUERY_JS);
        }

        public Url(@Nonnull String bootstrapCss, @Nonnull String jQueryJs) {
            this.bootstrapCss = (String)Assert.hasLength((CharSequence)bootstrapCss, (Object[])new String[]{"bootstrapCss"});
            this.jQueryJs = (String)Assert.hasLength((CharSequence)jQueryJs, (Object[])new String[]{"jQueryJs"});
        }
    }
}

