/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.sql;

import java.util.List;
import javax.annotation.Nonnull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.jdbc.JdbcBuilder;

public class SqlBuilder
extends JdbcBuilder {
    public SqlBuilder() {
    }

    public SqlBuilder(List<CharSequence> sql, List<Object> arguments) {
        super(sql, arguments);
    }

    public SqlBuilder select(CharSequence ... columns) {
        super.write((CharSequence)"SELECT");
        for (CharSequence column : columns) {
            super.column(column);
        }
        return this;
    }

    public SqlBuilder from(CharSequence ... tables) {
        super.write((CharSequence)"FROM");
        for (CharSequence table : tables) {
            super.write(table);
        }
        return this;
    }

    public SqlBuilder where() {
        super.write((CharSequence)"WHERE");
        return this;
    }

    public SqlBuilder insert(@Nonnull CharSequence table) {
        Assert.hasLength((CharSequence)table, (Object[])new String[]{"table"});
        super.write((CharSequence)"INSERT INTO");
        super.write(table);
        return this;
    }

    public SqlBuilder update(@Nonnull CharSequence table) {
        Assert.hasLength((CharSequence)table, (Object[])new String[]{"table"});
        super.write((CharSequence)"UPDATE");
        super.write(table);
        super.write((CharSequence)"SET");
        return this;
    }

    public SqlBuilder delete(@Nonnull CharSequence table) {
        Assert.hasLength((CharSequence)table, (Object[])new String[]{"table"});
        super.write((CharSequence)"DELETE");
        super.write((CharSequence)"FROM");
        super.write(table);
        super.write((CharSequence)"SET");
        return this;
    }

    public SqlBuilder addArguments(Object ... values) {
        return (SqlBuilder)super.addArguments(values);
    }

    protected SqlBuilder addValue(Object value) {
        return (SqlBuilder)super.addValue(value);
    }

    public SqlBuilder value(Object value) {
        return (SqlBuilder)super.value(value);
    }

    public SqlBuilder condition(CharSequence sqlCondition, String operator, Object value) {
        return (SqlBuilder)super.condition(sqlCondition, operator, value);
    }

    public SqlBuilder orCondition(CharSequence sqlCondition, String operator, Object ... values) {
        return (SqlBuilder)super.orCondition(sqlCondition, operator, values);
    }

    public SqlBuilder orCondition(CharSequence sqlCondition, String operator, Object value) {
        return (SqlBuilder)super.orCondition(sqlCondition, operator, value);
    }

    public SqlBuilder andCondition(CharSequence sqlCondition, String operator, Object ... values) {
        return (SqlBuilder)super.andCondition(sqlCondition, operator, values);
    }

    public SqlBuilder andCondition(CharSequence sqlCondition, String operator, Object value) {
        return (SqlBuilder)super.andCondition(sqlCondition, operator, value);
    }

    public SqlBuilder columnInsert(CharSequence column, Object value) {
        return (SqlBuilder)super.columnInsert(column, value);
    }

    public SqlBuilder columnUpdate(CharSequence column, Object value) {
        return (SqlBuilder)super.columnUpdate(column, value);
    }

    public final SqlBuilder column(CharSequence column) {
        return (SqlBuilder)super.column(column);
    }

    public final SqlBuilder writeManyNoSpace(CharSequence ... sqlFragments) {
        return (SqlBuilder)super.writeManyNoSpace(sqlFragments);
    }

    public final SqlBuilder writeMany(CharSequence ... sqlFragments) {
        return (SqlBuilder)super.writeMany(sqlFragments);
    }

    public final SqlBuilder writeNoSpace(CharSequence sqlFragment) {
        return (SqlBuilder)super.writeNoSpace(sqlFragment);
    }

    public final SqlBuilder write(CharSequence sqlFragment) {
        return (SqlBuilder)super.write(sqlFragment);
    }

    public final SqlBuilder write(SqlBuilder builder) {
        return (SqlBuilder)super.write((JdbcBuilder)builder);
    }
}

