/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ao.HttpParameter;

public class JQueryWriter
extends JavaScriptWriter {
    public JQueryWriter() {
    }

    public JQueryWriter(CharSequence ... inputSelectors) {
        super(inputSelectors);
    }

    public JQueryWriter(Duration idleDelay, HttpParameter ajaxRequestParam, HttpParameter sortRequestParam, CharSequence ... inputSelectors) {
        super(idleDelay, ajaxRequestParam, sortRequestParam, inputSelectors);
    }

    @Override
    public void write(@Nonnull Element parent) {
        try (Element js = parent.addElement("script");){
            js.addRawText((Object)this.newLine);
            js.addRawText("var f", this.fceOrder, "=function(){");
            if (Check.hasLength((Object[])this.inputCssSelectors)) {
                String inpSelectors = Stream.of(this.inputCssSelectors).collect(Collectors.joining(", "));
                js.addRawTexts(this.newLine, "", "var timeout=null, ajaxRun=false, submitReq=false;", "$('" + inpSelectors + "').keyup(function(){", "  if(timeout){clearTimeout(timeout);}", "  timeout=setTimeout(function(){", "    timeout=null;", "    if(ajaxRun){submitReq=true;}", "    else{$('" + this.formSelector + "').submit();}", "  }, " + this.idleDelay.toMillis() + ");", "});");
            }
            js.addRawTexts(this.newLine, "", "$('form').submit(function(event){", "  event.preventDefault();", "  ajaxRun=true;", "  var data=$('" + this.formSelector + "').serialize();", "  $.ajax(" + (this.version == 2 ? "{ url:'" + this.ajaxRequestPath + "'" : "{ url:'?" + this.ajaxRequestParam + "=true'") + ", type:'POST', data:data, timeout:" + this.ajaxTimeout.toMillis() + ", error:function(xhr,ajaxOptions,thrownError){", Check.hasLength((CharSequence)this.subtitleSelector) ? "   ajaxRun=false; $('" + this.subtitleSelector + "').html('" + this.errorMessage + ":' + thrownError);" : "", "  }, success:function(result){", "    var jsn=JSON.parse(result);", "    $.each(jsn,function(key,value){", "      $(key).html(value);", "    }); ", "    if(submitReq){submitReq=false; $('" + this.formSelector + "').submit();} ", "    else{ajaxRun=false;}", "  }});", "});");
            if (this.onLoadSubmit) {
                js.addRawText(this.newLine, "  $('" + this.formSelector + "').submit();");
            }
            js.addRawText((Object)"};");
            if (this.isSortable) {
                js.addRawText(this.newLine, "f1.sort=function(col){");
                js.addRawText(this.newLine, " document.querySelector('", "input[name=\"", this.sortRequestParam, "\"]').value=col;");
                js.addRawText(this.newLine, " if(this.ajaxRun){this.submitReq=true;}");
                js.addRawText(this.newLine, " else{document.querySelector('", this.formSelector, "').submit();}");
                js.addRawText(this.newLine, "};");
            }
            js.addRawText("$(document).ready(f", this.fceOrder, ");");
        }
    }
}

