/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.TableBuilderConfigImpl;
import org.ujorm.tools.xml.config.HtmlConfig;

public interface TableBuilderConfig<D> {
    @Nonnull
    public HtmlConfig getConfig();

    @Nonnull
    public String getCssLink();

    @Nonnull
    public String getJavascriptLink();

    @Nonnull
    public Duration getIdleDelay();

    @Nonnull
    public HttpParameter getAjaxRequestParam();

    @Nonnull
    public HttpParameter getSortRequestParam();

    @Nonnull
    public CharSequence getAjaxReadyMessage();

    @Nonnull
    public String getFormId();

    @Nonnull
    public String getControlCss();

    @Nonnull
    public String getSubtitleCss();

    @Nonnull
    public CharSequence getTableSelector();

    @Nonnull
    public List<CharSequence> getTableCssClass();

    @Nonnull
    public CharSequence getSortable();

    @Nonnull
    public CharSequence getSortableAsc();

    @Nonnull
    public CharSequence getSortableDesc();

    @Nonnull
    public CharSequence getSortableBoth();

    public boolean isEmbeddedIcons();

    public BiConsumer<Element, Boolean> getCssWriter();

    @Nonnull
    default public CharSequence getSortableDirection(@Nonnull Direction direction) {
        switch (direction) {
            case ASC: {
                return this.getSortableAsc();
            }
            case DESC: {
                return this.getSortableDesc();
            }
            case NONE: {
                return this.getSortableBoth();
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @Nullable
    default public InputStream getInnerSortableImageToStream(@Nonnull Direction direction) {
        return this.getClass().getResourceAsStream(this.getInnerSortableImage(direction));
    }

    @Nonnull
    default public String getInnerSortableImage(@Nonnull Direction direction) {
        String baseDir = "/META-INF/resources/org/ujorm/images/v1/order";
        switch (direction) {
            case ASC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "up.png");
            }
            case DESC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "down.png");
            }
            case NONE: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "both.png");
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @Nonnull
    public static TableBuilderConfigImpl of(@Nonnull HtmlConfig config) {
        return new TableBuilderConfigImpl(config);
    }
}

