/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.Html;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.builder.XmlPrinter;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;
import org.ujorm.tools.xml.model.XmlModel;
import org.ujorm.tools.xml.model.XmlWriter;

public class HtmlElement
implements ApiElement<Element>,
Html {
    @Nonnull
    private final Element root;
    @Nonnull
    private Element head;
    @Nonnull
    private Element body;
    @Nonnull
    private final HtmlConfig config;
    @Nonnull
    private final Appendable writer;

    public HtmlElement(@Nonnull HtmlConfig config, @Nonnull Appendable writer) {
        this((ApiElement)new XmlModel((CharSequence)"html"), config, writer);
    }

    public HtmlElement(@Nonnull ApiElement root, @Nonnull HtmlConfig config, @Nonnull Appendable writer) {
        this.root = new Element(root);
        this.config = config;
        this.writer = writer;
    }

    public CharSequence getName() {
        return this.root.getName();
    }

    public Element setAttribute(String name, Object value) {
        return this.root.setAttribute(name, value);
    }

    public Element addText(Object value) {
        return this.root.addText(value);
    }

    public Element addTextTemplated(@Nonnull CharSequence template, Object ... values) {
        return this.root.addTextTemplated(template, values);
    }

    public Element addRawText(Object value) {
        return this.root.addRawText(value);
    }

    public Element addComment(CharSequence comment) {
        return this.root.addComment(comment);
    }

    @Deprecated
    public Element addCDATA(CharSequence charData) {
        return this.root.addCDATA(charData);
    }

    @Nonnull
    public final Element addElement(@Nonnull String name) throws IllegalStateException {
        switch (name) {
            case "head": {
                return this.getHead();
            }
            case "body": {
                return this.getBody();
            }
        }
        return this.root.addElement(name);
    }

    public Element getHead() {
        if (this.head == null) {
            this.head = this.root.addElement("head");
        }
        return this.head;
    }

    public Element addHead() {
        return this.getHead();
    }

    @Nonnull
    public Element getBody() {
        if (this.body == null) {
            this.body = this.root.addElement("body");
        }
        return this.body;
    }

    @Nonnull
    public Element addBody() {
        return this.getBody();
    }

    public void addJavascriptLinks(boolean defer, CharSequence ... javascriptLinks) {
        for (CharSequence js : javascriptLinks) {
            this.addJavascriptLink(defer, js);
        }
    }

    public Element addJavascriptLink(boolean defer, @Nonnull CharSequence javascriptLink) {
        Assert.notNull((Object)javascriptLink, (Object[])new String[]{"The argument {} is required", "javascriptLink"});
        return this.getHead().addElement("script").setAttribute("src", javascriptLink).setAttribute("defer", defer ? "defer" : null).addText((Object)"");
    }

    @Deprecated
    public Element addJavascriptContents(@Nonnull CharSequence javascript) {
        return this.addJavascriptBody(javascript);
    }

    public Element addJavascriptBody(CharSequence ... javascript) {
        if (Check.hasLength((Object[])javascript)) {
            Element result = this.getHead().addElement("script").setAttribute("language", "javascript").setAttribute("type", "text/javascript");
            int max = javascript.length;
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    result.addRawText((Object)"\n");
                }
                result.addRawText((Object)javascript[i]);
            }
            return result;
        }
        return this.head;
    }

    public void addCssLinks(CharSequence ... css) {
        for (CharSequence cssLink : css) {
            this.addCssLink(cssLink);
        }
    }

    public Element addCssLink(@Nonnull CharSequence css) {
        Assert.notNull((Object)css, (Object[])new String[]{"The argument {} is required", "css"});
        return this.getHead().addElement("link").setAttribute("href", css).setAttribute("rel", "stylesheet");
    }

    public Element addCssBody(@Nonnull CharSequence css) {
        Assert.notNull((Object)css, (Object[])new String[]{"The argument {} is required", "css"});
        return this.getHead().addElement("style").addRawText((Object)css);
    }

    public Element addCssBodies(@Nonnull CharSequence lineSeparator, CharSequence ... css) {
        Assert.hasLength((Object[])css, (Object[])new String[]{"The argument {} is required", "css"});
        Element result = this.getHead().addElement("style");
        int max = css.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                result.addRawText((Object)lineSeparator);
            }
            result.addRawText((Object)css[i]);
        }
        return result;
    }

    @Nonnull
    public Element original() {
        return this.root;
    }

    @Nonnull
    public String toString() throws IllegalStateException {
        return this.writer.toString();
    }

    public void close() throws IllegalStateException {
        this.root.close();
        if (this.root.internalElement instanceof XmlModel) {
            XmlModel xmlElement = (XmlModel)this.root.internalElement;
            try {
                CharSequence doctype = this.config.getDoctype();
                XmlWriter xmlWriter = new XmlWriter(this.writer.append(doctype).append(doctype.length() == 0 ? "" : this.config.getNewLine()), this.config.getIndentation());
                xmlElement.toWriter(this.config.getFirstLevel() + 1, xmlWriter);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Nonnull
    public HtmlConfig getConfig() {
        return this.config;
    }

    public CharSequence getTitle() {
        return this.getConfig().getTitle();
    }

    @Nonnull
    public static HtmlElement of(@Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setCssLinks(cssLinks);
        return HtmlElement.of((HtmlConfig)config, response);
    }

    @Nonnull
    public static HtmlElement of(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of((HtmlConfig)config, response);
    }

    @Nonnull
    public static HtmlElement of(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, @Nonnull Charset charset, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of((HtmlConfig)config, response);
    }

    @Nonnull
    public static HtmlElement niceOf(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of((HtmlConfig)config, response);
    }

    @Nonnull
    public static HtmlElement niceOf(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, @Nonnull Charset charset, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCharset(charset);
        config.setCssLinks(cssLinks);
        return HtmlElement.of((HtmlConfig)config, response);
    }

    @Nonnull
    public static HtmlElement niceOf(@Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setCssLinks(cssLinks);
        return HtmlElement.of((HtmlConfig)config, response);
    }

    @Nonnull
    public static HtmlElement of(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IllegalStateException, UnsupportedEncodingException {
        return HtmlElement.of(request, response, (HtmlConfig)HtmlConfig.ofDefault());
    }

    @Nonnull
    public static HtmlElement of(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull HtmlConfig config) throws IllegalStateException, UnsupportedEncodingException {
        request.setCharacterEncoding(config.getCharset().toString());
        return HtmlElement.of(config, response);
    }

    @Deprecated
    @Nonnull
    public static HtmlElement of(@Nonnull HttpServletResponse response, @Nonnull HtmlConfig config) throws IllegalStateException {
        return HtmlElement.of(config, response);
    }

    @Nonnull
    public static HtmlElement of(@Nonnull HtmlConfig config, @Nonnull HttpServletResponse response) throws IllegalStateException {
        response.setCharacterEncoding(config.getCharset().toString());
        response.setContentType(config.getContentType());
        try {
            return HtmlElement.of(config, response.getWriter());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public static HtmlElement of(@Nullable HtmlConfig config) throws IllegalStateException {
        return HtmlElement.of((HtmlConfig)(config != null ? config : HtmlConfig.ofDefault()), new StringBuilder(256));
    }

    public static HtmlElement of(@Nonnull HtmlConfig config, @Nonnull Appendable writer) throws IllegalStateException {
        XmlModel root = config.isDocumentObjectModel() ? new XmlModel(config.getRootElementName()) : new XmlBuilder(config.getRootElementName(), new XmlPrinter(writer, (XmlConfig)config), config.getFirstLevel());
        HtmlElement result = new HtmlElement((ApiElement)root, config, writer);
        if (config.isHtmlHeaderRequest()) {
            config.getLanguage().ifPresent(lang -> result.setAttribute("lang", lang));
            result.getHead().addElement("meta").setAttribute("charset", config.getCharset());
            result.getHead().addElement("title").addText((Object)config.getTitle());
            result.addCssLinks(config.getCssLinks());
            config.getHeaderInjector().write((ApiElement)result.getHead());
            CharSequence rawHeaderText = config.getRawHeaderText();
            if (Check.hasLength((CharSequence)rawHeaderText)) {
                result.getHead().addRawText((Object)config.getNewLine());
                result.getHead().addRawText((Object)rawHeaderText);
            }
        }
        return result;
    }
}

