/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;

public class JavaScriptWriter
implements Injector {
    public static final HttpParameter DEFAULT_AJAX_REQUEST_PARAM = HttpParameter.of("_ajax");
    public static final HttpParameter DEFAULT_SORT_REQUEST_PARAM = HttpParameter.of("_sort");
    public static final Duration DEFAULT_DURATION = Duration.ofMillis(250L);
    protected final HttpParameter ajaxRequestParam;
    protected final HttpParameter sortRequestParam;
    protected final CharSequence[] inputCssSelectors;
    @Nonnull
    protected Duration idleDelay = DEFAULT_DURATION;
    protected String formSelector = "form";
    protected boolean onLoadSubmit = false;
    protected CharSequence newLine = "\n";
    @Nullable
    protected CharSequence subtitleSelector;
    @Nonnull
    protected CharSequence errorMessage = "AJAX fails due";
    @Nonnull
    protected Duration ajaxTimeout = Duration.ofMillis(30000L);
    protected int version = 1;
    protected String ajaxRequestPath = "_ajax";
    protected boolean isSortable = true;
    protected int fceOrder = 1;
    protected boolean isAjax = true;

    public JavaScriptWriter() {
        this("form input");
    }

    public JavaScriptWriter(CharSequence ... inputSelectors) {
        this(DEFAULT_DURATION, DEFAULT_AJAX_REQUEST_PARAM, DEFAULT_SORT_REQUEST_PARAM, inputSelectors);
    }

    public JavaScriptWriter(@Nonnull Duration idleDelay, @Nonnull HttpParameter ajaxRequestParam, @Nonnull HttpParameter sortRequestParam, CharSequence ... inputSelectors) {
        this.idleDelay = (Duration)Assert.notNull((Object)idleDelay, (Object[])new String[]{"idleDelay"});
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        this.sortRequestParam = (HttpParameter)Assert.notNull((Object)sortRequestParam, (Object[])new String[]{"sortRequestParam"});
        this.inputCssSelectors = (CharSequence[])Assert.hasLength((Object[])inputSelectors, (Object[])new String[]{"inputSelectors"});
    }

    public JavaScriptWriter setFormSelector(String formSelector) {
        this.formSelector = (String)Assert.notNull((Object)formSelector, (Object[])new String[]{"formSelector"});
        return this;
    }

    public JavaScriptWriter setOnLoadSubmit(boolean onLoadSubmit) {
        this.onLoadSubmit = onLoadSubmit;
        return this;
    }

    public JavaScriptWriter setNewLine(@Nonnull CharSequence newLine) {
        this.newLine = (CharSequence)Assert.notNull((Object)newLine, (Object[])new String[]{"newLine"});
        return this;
    }

    public JavaScriptWriter setSubtitleSelector(CharSequence subtitleSelector) {
        this.subtitleSelector = subtitleSelector;
        return this;
    }

    public JavaScriptWriter setErrorMessage(@Nullable CharSequence errorMessage) {
        this.errorMessage = Assert.hasLength((CharSequence)errorMessage, (Object[])new String[]{"errorMessage"});
        return this;
    }

    public JavaScriptWriter setAjaxTimeout(@Nonnull Duration ajaxTimeout) {
        this.ajaxTimeout = (Duration)Assert.notNull((Object)ajaxTimeout, (Object[])new String[]{"ajaxTimeout"});
        return this;
    }

    public JavaScriptWriter setAjaxRequestPath(@Nonnull String ajaxRequestPath) {
        this.ajaxRequestPath = ajaxRequestPath;
        this.setVersion(2);
        return this;
    }

    public JavaScriptWriter setVersion(int version) {
        this.version = version;
        return this;
    }

    public JavaScriptWriter setSortable(boolean isSortable) {
        this.isSortable = isSortable;
        return this;
    }

    public JavaScriptWriter setSortable(int fceOrder) {
        this.fceOrder = fceOrder;
        return this;
    }

    public int getFceOrder() {
        return this.fceOrder;
    }

    public JavaScriptWriter setAjax(boolean ajax) {
        this.isAjax = ajax;
        return this;
    }

    public boolean isAjax() {
        return this.isAjax;
    }

    @Override
    public void write(@Nonnull Element parent) {
        String inpSelectors = Check.hasLength((Object[])this.inputCssSelectors) ? Stream.of(this.inputCssSelectors).collect(Collectors.joining(", ")) : "#!@";
        try (Element js = parent.addElement("script");){
            js.addRawText(this.newLine, "/* jshint esversion:6 */");
            if (this.isAjax) {
                js.addRawText(this.newLine, "var f", this.fceOrder, "=function(){");
                js.addRawTexts(this.newLine, "", "var timeout=null, ajaxRun=false, submitReq=false;", "document.querySelectorAll('" + inpSelectors + "').forEach(item=>{item.addEventListener('keyup',e=>{", "  if(timeout){clearTimeout(timeout);}", "  timeout=setTimeout(()=>{", "    timeout=null;", "    if(ajaxRun) submitReq=true; ", "    else process(null);", "  }, " + this.idleDelay.toMillis() + ");}, false);", "});", "document.querySelector('#form').addEventListener('submit', process, false);");
                if (this.onLoadSubmit) {
                    js.addRawText(this.newLine, "process(null);");
                }
                js.addRawTexts(this.newLine, "", "function process(e){", "  if(e!==null) e.preventDefault();", "  fetch('" + (this.version == 2 ? this.ajaxRequestPath : "?" + this.ajaxRequestPath + "=true") + "', {", "    method:'POST',", "    body:new URLSearchParams(new FormData(document.querySelector('" + this.formSelector + "'))),", "    headers:{'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8'},", "  })", "  .then(response=>response.json())", "  .then(data=>{", "    for (var key of Object.keys(data))", "      document.querySelectorAll(key).forEach(i=>{i.innerHTML=data[key];})", "    if(submitReq){submitReq=false;process(e);}", "    else{ajaxRun=false;}", "  }).catch((err)=>{", "    ajaxRun=false;", "    document.querySelector('" + this.subtitleSelector + "').innerHTML='" + this.errorMessage + ": ' + err;", "  });", "}");
                if (this.isSortable) {
                    js.addRawText(this.newLine, "function sort(col){");
                    js.addRawText(this.newLine, "  document.querySelector('", "input[name=\"", this.sortRequestParam, "\"]').value=col;");
                    js.addRawText(this.newLine, "  if(this.ajaxRun){this.submitReq=true;}");
                    js.addRawText(this.newLine, "  else{this.process(null);}");
                    js.addRawText(this.newLine, "} f", this.fceOrder, ".process=process;f", this.fceOrder, ".sort=sort;");
                }
                js.addRawTexts(this.newLine, "};");
                js.addRawText(this.newLine, "document.addEventListener('DOMContentLoaded',f", this.fceOrder, ");");
            } else if (this.isSortable) {
                js.addRawText(this.newLine, "var f", this.fceOrder, "={");
                js.addRawText(this.newLine, "  sort:col=>{");
                js.addRawText(this.newLine, "  document.querySelector('", "input[name=\"", this.sortRequestParam, "\"]').value=col;");
                js.addRawText(this.newLine, "  document.querySelector('" + this.formSelector + "').submit();");
                js.addRawText(this.newLine, "}}");
            }
        }
    }
}

