/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ao;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import org.ujorm.tools.Check;

public abstract class WebUtils {
    public static final <V> boolean isType(@Nonnull Class type, V ... items) {
        boolean result = false;
        for (V item : items) {
            if (!type.isInstance(item)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static final boolean isType(Class type, @Nonnull Stream<Object> items) {
        boolean[] result = new boolean[]{false};
        items.filter(t -> !result[0]).forEach(t -> {
            if (type.isInstance(t)) {
                result[0] = true;
            }
        });
        return result[0];
    }

    @Nonnull
    public static String urlOfServlet(@Nonnull Class<? extends HttpServlet> servlet, String ... params) {
        String result = WebUtils.urlOfServlet(servlet, new String[0]);
        if (Check.hasLength((Object[])params) && params[0] != null) {
            return result + "?" + String.join((CharSequence)"&", params);
        }
        return result;
    }

    @Nonnull
    public static String urlOfServlet(@Nonnull Class<? extends HttpServlet> servlet, @Nonnull String defaultUrl) {
        WebServlet[] webServlets;
        for (WebServlet webServlet : webServlets = (WebServlet[])servlet.getAnnotationsByType(WebServlet.class)) {
            for (String link : webServlet.value()) {
                if (!Check.hasLength((CharSequence)link)) continue;
                return link;
            }
        }
        return defaultUrl;
    }
}

