/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ao;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.ao.DefaultHttpParam;

public interface HttpParameter
extends CharSequence {
    @Override
    @Nonnull
    public String toString();

    @Override
    default public int length() {
        return this.toString().length();
    }

    @Override
    default public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    default public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Nonnull
    default public String defaultValue() {
        return "";
    }

    @Nonnull
    default public String of(@Nonnull ServletRequest request) {
        return this.of(request, (String)Assert.notNull((Object)this.defaultValue(), (Object[])new String[]{"Default value is required"}));
    }

    @Nonnull
    default public String of(@Nonnull ServletRequest request, @Nonnull String defaultValue) {
        String result = request.getParameter(this.toString());
        return result != null ? result : defaultValue;
    }

    default public boolean of(@Nonnull ServletRequest request, @Nullable boolean defaultValue) {
        switch (this.of(request)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return defaultValue;
    }

    default public char of(@Nonnull ServletRequest request, @Nullable char defaultValue) {
        String value = this.of(request);
        return value.isEmpty() ? defaultValue : value.charAt(0);
    }

    default public short of(@Nonnull ServletRequest request, @Nullable short defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public int of(@Nonnull ServletRequest request, @Nullable int defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public long of(@Nonnull ServletRequest request, @Nullable long defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public float of(@Nonnull ServletRequest request, @Nullable float defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public double of(@Nonnull ServletRequest request, @Nullable double defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public <V> V of(@Nonnull ServletRequest request, @Nonnull V defaultValue, @Nonnull Function<String, V> decoder) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return decoder.apply(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static HttpParameter of(@Nonnull String name) {
        return new DefaultHttpParam(name, "");
    }

    public static HttpParameter of(@Nonnull String name, @Nonnull String defaultValue) {
        return new DefaultHttpParam(name, defaultValue);
    }
}

