/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.report;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ajax.ReqestDispatcher;
import org.ujorm.tools.web.ao.Column;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.web.report.ReportBuilderConfig;
import org.ujorm.tools.web.report.ReportBuilderConfigImpl;
import org.ujorm.tools.web.table.ColumnModel;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.GridBuilder;
import org.ujorm.tools.xml.config.HtmlConfig;

public class ReportBuilder<D> {
    private static final Logger LOGGER = Logger.getLogger(ReportBuilder.class.getName());
    private static final HttpParameter UNDEFINED_PARAM = HttpParameter.of("UNDEFINED_PARAM");
    @Nonnull
    protected final GridBuilder<D> gridBuilder;
    protected final ReportBuilderConfig config;
    @Nonnull
    protected HttpParameter ajaxRequestParam = JavaScriptWriter.DEFAULT_AJAX_REQUEST_PARAM;
    @Nonnull
    protected Injector htmlHeader = e -> {};
    @Nonnull
    protected Injector header = e -> e.addHeading(this.config.getConfig().getTitle(), new CharSequence[0]);
    @Nonnull
    protected Injector footer;
    @Nonnull
    protected Injector formAdditions = this.footer = e -> e.addText((Object)"");
    @Nonnull
    protected Supplier<Injector> javascritWriter = () -> new JavaScriptWriter().setSortable(this.gridBuilder.isSortable()).setAjax(this.ajaxEnabled).setSubtitleSelector("." + this.config.getSubtitleCss());
    protected boolean ajaxEnabled = true;
    protected boolean autoSubmmitOnLoad = false;
    @Nullable
    private int sortedColumn = -1;

    public ReportBuilder(@Nonnull CharSequence title) {
        this((HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public ReportBuilder(@Nonnull HtmlConfig config) {
        this(ReportBuilderConfig.of(config));
    }

    public ReportBuilder(@Nonnull ReportBuilderConfig config) {
        this(config, new GridBuilder(config));
    }

    public ReportBuilder(@Nonnull ReportBuilderConfig config, @Nonnull GridBuilder<D> builder) {
        this.gridBuilder = builder;
        this.config = config;
    }

    @Nonnull
    public <V> ReportBuilder<D> add(Function<D, V> column) {
        this.gridBuilder.add(column);
        return this;
    }

    @Nonnull
    public <V> ReportBuilder<D> add(Function<D, V> column, CharSequence title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @Nonnull
    public <V> ReportBuilder<D> add(Function<D, V> column, Injector title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @Nonnull
    public <V> ReportBuilder<D> add(Function<D, V> column, CharSequence title, @Nullable HttpParameter param) {
        this.gridBuilder.add(column, title, param);
        return this;
    }

    @Nonnull
    public <V> ReportBuilder<D> add(Function<D, V> column, Injector title, @Nullable HttpParameter param) {
        this.gridBuilder.add(column, title, param);
        return this;
    }

    @Nonnull
    public ReportBuilder<D> addColumn(@Nonnull Column<D> column, @Nonnull CharSequence title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @Nonnull
    public ReportBuilder<D> addColumn(@Nonnull Column<D> column, @Nonnull Injector title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @Nonnull
    public ReportBuilder<D> addOrder(@Nonnull CharSequence title) {
        this.gridBuilder.addOrder(title);
        return this;
    }

    public ColumnModel<D, ?> getColumn(int index) {
        return this.gridBuilder.getColumn(index);
    }

    public int getColumnSize() {
        return this.gridBuilder.getColumnSize();
    }

    @Nonnull
    public <V> ReportBuilder<D> sortable() {
        this.gridBuilder.sortable();
        return this;
    }

    @Nonnull
    public <V> ReportBuilder<D> sortable(@Nullable boolean ascending) {
        this.gridBuilder.sortable(ascending);
        return this;
    }

    @Nonnull
    public <V> ReportBuilder<D> sortable(@Nonnull Direction direction) {
        this.gridBuilder.sortable(direction);
        return this;
    }

    @Nonnull
    public ColumnModel<D, ?> getSortedColumn() {
        return this.gridBuilder.getSortedColumn();
    }

    @Nonnull
    public ReportBuilder<D> setAjaxRequestParam(@Nonnull HttpParameter ajaxRequestParam) {
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        return this;
    }

    @Nonnull
    public ReportBuilder<D> setHtmlHeader(@Nonnull Injector htmlHeader) {
        this.htmlHeader = (Injector)Assert.notNull((Object)htmlHeader, (Object[])new String[]{"htmlHeader"});
        return this;
    }

    @Nonnull
    public ReportBuilder<D> setHeader(@Nonnull Injector header) {
        this.header = (Injector)Assert.notNull((Object)header, (Object[])new String[]{"header"});
        return this;
    }

    @Nonnull
    public ReportBuilder<D> setFooter(@Nonnull Injector footer) {
        this.footer = (Injector)Assert.notNull((Object)footer, (Object[])new String[]{"footer"});
        return this;
    }

    @Nonnull
    public ReportBuilder<D> setFormItem(@Nonnull Injector formItem) {
        this.formAdditions = (Injector)Assert.notNull((Object)formItem, (Object[])new String[]{"formAdditions"});
        return this;
    }

    @Deprecated
    @Nonnull
    public ReportBuilder<D> setFormAdditions(@Nonnull Injector formItem) {
        return this.setFormItem(formItem);
    }

    public ReportBuilder<D> setAjaxEnabled(boolean ajaxEnabled) {
        this.ajaxEnabled = ajaxEnabled;
        return this;
    }

    public ReportBuilder<D> setJavascritWriter(@Nonnull Supplier<Injector> javascritWriter) {
        this.javascritWriter = (Supplier)Assert.notNull(javascritWriter, (Object[])new String[]{"javascritWriter"});
        return this;
    }

    public ReportBuilder<D> setEmbeddedIcons(boolean embeddedIcons) throws IllegalStateException {
        if (!(this.config instanceof ReportBuilderConfigImpl)) {
            throw new IllegalStateException("Configuration must be type of: " + ReportBuilderConfigImpl.class);
        }
        ((ReportBuilderConfigImpl)this.config).setEmbeddedIcons(embeddedIcons);
        return this;
    }

    public void build(@Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output, @Nonnull Stream<D> resource) {
        this.build(input, output, (GridBuilder<D> tableBuilder) -> resource);
    }

    public void build(@Nonnull HttpServletRequest input, @Nonnull HttpServletResponse output, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) {
        try {
            this.setSort(ColumnModel.ofCode(this.config.getSortRequestParam().of((ServletRequest)input)));
            new ReqestDispatcher(input, output, this.config.getConfig()).onParam(this.config.getAjaxRequestParam(), jsonBuilder -> this.doAjax(input, (JsonBuilder)jsonBuilder, resource)).onDefaultToElement(element -> this.printHtmlBody(input, element, resource));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Internal server error", e);
            output.setStatus(500);
        }
    }

    protected void setSort(@Nonnull ColumnModel sort) {
        this.sortedColumn = sort.getIndex();
        if (this.sortedColumn >= 0) {
            int[] i = new int[]{-1};
            this.gridBuilder.getColumns().forEach(cm -> {
                i[0] = i[0] + 1;
                if (cm.isSortable()) {
                    cm.setDirection(sort.getIndex() == i[0] ? sort.getDirection() : Direction.NONE);
                }
            });
        }
    }

    protected void printHtmlBody(@Nonnull HttpServletRequest input, @Nonnull HtmlElement html, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) {
        Assert.notNull((Object)input, (Object[])new String[]{"input"});
        Assert.notNull((Object)html, (Object[])new String[]{"html"});
        Assert.notNull(resource, (Object[])new String[]{"resource"});
        if (Check.hasLength((CharSequence)this.config.getJavascriptLink())) {
            html.addJavascriptLink(false, this.config.getJavascriptLink());
        }
        html.addCssLink(this.config.getCssLink());
        this.config.getCssWriter().accept(html.getHead(), this.gridBuilder.isSortable());
        this.javascritWriter.get().write(html.getHead());
        this.htmlHeader.write(html.getHead());
        try (Element body = html.getBody();){
            this.header.write(body);
            body.addDiv(this.config.getSubtitleCss()).addText((Object)(this.ajaxEnabled ? this.config.getAjaxReadyMessage() : ""));
            try (Element form = body.addForm(new CharSequence[0]).setId(this.config.getFormId()).setMethod("post").setAction("?");){
                this.gridBuilder.getColumns().forEach(column -> {
                    if (column.isFiltered()) {
                        HttpParameter param = column.getParam(UNDEFINED_PARAM);
                        form.addTextInp(param, param.of((ServletRequest)input), column.getTitle(), this.config.getControlCss(), column.getParam(UNDEFINED_PARAM));
                    }
                });
                if (this.gridBuilder.isSortable()) {
                    form.addInput(new CharSequence[0]).setAttribute("type", "hidden").setName(this.config.getSortRequestParam()).setValue(this.config.getSortRequestParam().of((ServletRequest)input));
                }
                form.addInput(new CharSequence[0]).setType("submit").setAttribute("hidden");
                this.formAdditions.write(form);
            }
            List<CharSequence> tableCss = this.config.getTableCssClass();
            this.printTableBody(body.addTable(tableCss.toArray(new CharSequence[tableCss.size()])), input, resource);
            this.footer.write(body);
        }
    }

    protected void printTableBody(@Nonnull Element table, @Nonnull HttpServletRequest input, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) {
        Element headerElement = table.addElement("thead").addElement("tr");
        ColumnModel sortedColumn = ColumnModel.ofCode(this.config.getSortRequestParam().of((ServletRequest)input));
        this.gridBuilder.build(table, sortedColumn, resource);
    }

    protected void doAjax(@Nonnull HttpServletRequest input, @Nonnull JsonBuilder output, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) throws ServletException, IOException {
        output.writeClass(this.config.getTableSelector(), e -> this.printTableBody(e, input, resource));
        output.writeClass((CharSequence)this.config.getSubtitleCss(), this.config.getAjaxReadyMessage());
    }

    public static class Url {
        protected static final String BOOTSTRAP_CSS = "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css";
        protected static final String JQUERY_JS = "";
        final String bootstrapCss;

        public Url() {
            this(BOOTSTRAP_CSS, JQUERY_JS);
        }

        public Url(@Nonnull String bootstrapCss, @Nonnull String jQueryJs) {
            this.bootstrapCss = (String)Assert.hasLength((CharSequence)bootstrapCss, (Object[])new String[]{"bootstrapCss"});
        }
    }
}

