/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.Column;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;
import org.ujorm.tools.web.ao.WebUtils;
import org.ujorm.tools.web.table.ColumnModel;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.GridBuilderConfig;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.config.HtmlConfig;

public class GridBuilder<D> {
    private static final Logger LOGGER = Logger.getLogger(GridBuilder.class.getName());
    protected final List<ColumnModel<D, ?>> columns = new ArrayList();
    protected final GridBuilderConfig config;
    private int sortedColumn = -1;
    private Boolean isSortable;

    public GridBuilder(@Nonnull CharSequence title) {
        this((HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public GridBuilder(@Nonnull HtmlConfig config) {
        this(GridBuilderConfig.of(config));
    }

    public GridBuilder(@Nonnull GridBuilderConfig config) {
        this.config = config;
    }

    @Nonnull
    public <V> GridBuilder<D> add(Function<D, V> column) {
        return this.addInternal(column, "Column-" + (this.columns.size() + 1), null);
    }

    @Nonnull
    public <V> GridBuilder<D> add(Function<D, V> column, CharSequence title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> GridBuilder<D> add(Function<D, V> column, Injector title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public <V> GridBuilder<D> add(Function<D, V> column, CharSequence title, @Nullable HttpParameter param) {
        return this.addInternal(column, title, param);
    }

    @Nonnull
    public <V> GridBuilder<D> add(Function<D, V> column, Injector title, @Nullable HttpParameter param) {
        return this.addInternal(column, title, param);
    }

    @Nonnull
    public GridBuilder<D> addColumn(@Nonnull Column<D> column, @Nonnull CharSequence title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public GridBuilder<D> addColumn(@Nonnull Column<D> column, @Nonnull Injector title) {
        return this.addInternal(column, title, null);
    }

    @Nonnull
    public GridBuilder<D> addOrder(@Nonnull CharSequence title) {
        String textRight = "text-right";
        return this.addColumn(new Column<D>(){
            final AtomicLong order = new AtomicLong();

            @Override
            public void write(Element e, D row) {
                e.setClass("class", "text-right").addText(this.apply((D)row), Character.valueOf('.'));
            }

            @Override
            public Object apply(D t) {
                return this.order.incrementAndGet();
            }
        }, (Element e) -> e.setClass("class", "text-right").addText((Object)title));
    }

    @Nonnull
    protected <V> GridBuilder<D> addInternal(@Nonnull Function<D, V> column, @Nonnull CharSequence title, @Nullable HttpParameter param) {
        this.columns.add(new ColumnModel<D, V>(this.columns.size(), column, title, param));
        return this;
    }

    public ColumnModel<D, ?> getColumn(int index) {
        return this.columns.get(index);
    }

    public int getColumnSize() {
        return this.columns.size();
    }

    @Nonnull
    public <V> GridBuilder<D> sortable() {
        return this.sortable(Direction.NONE);
    }

    @Nonnull
    public <V> GridBuilder<D> sortable(@Nullable boolean ascending) {
        return this.sortable(ascending ? Direction.ASC : Direction.DESC);
    }

    @Nonnull
    public <V> GridBuilder<D> sortable(@Nonnull Direction direction) {
        Assert.notNull((Object)((Object)direction), (Object[])new String[]{"direction"});
        Assert.hasLength(this.columns, (Object[])new String[]{"No column is available"});
        this.columns.get(this.columns.size() - 1).setSortable(direction);
        return this;
    }

    @Nonnull
    public ColumnModel<D, ?> getSortedColumn() {
        return this.sortedColumn >= 0 && this.sortedColumn < this.getColumnSize() ? this.getColumn(this.sortedColumn) : ColumnModel.ofStub();
    }

    public void build(@Nonnull ApiElement parent, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) {
        this.printTableBody(Element.of(parent), resource);
    }

    public void build(@Nonnull ApiElement parent, @Nonnull ColumnModel sortedColumn, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) {
        this.setSort((ColumnModel)Assert.notNull((Object)sortedColumn, (Object[])new String[]{"sortedColumn"}));
        this.printTableBody(Element.of(parent), resource);
    }

    protected void setSort(@Nonnull ColumnModel sort) {
        this.sortedColumn = sort.getIndex();
        if (this.sortedColumn >= 0) {
            int max = this.columns.size();
            for (int i = 0; i < max; ++i) {
                ColumnModel<D, ?> cm = this.columns.get(i);
                if (!cm.isSortable()) continue;
                cm.setDirection(sort.getIndex() == i ? sort.getDirection() : Direction.NONE);
            }
        }
    }

    protected void printTableBody(@Nonnull Element table, @Nonnull Function<GridBuilder<D>, Stream<D>> resource) {
        Element headerElement = table.addElement("thead").addElement("tr");
        for (ColumnModel<D, ?> col : this.columns) {
            InputStream img;
            Element thLink;
            boolean columnSortable = col.isSortable();
            CharSequence value2 = col.getTitle();
            Element th = headerElement.addElement("th");
            Element element = thLink = columnSortable ? th.addAnchor("javascript:f1.sort(" + col.toCode(true) + ")", new CharSequence[0]) : th;
            if (columnSortable) {
                thLink.setClass(this.config.getSortable(), this.config.getSortableDirection(col.getDirection()));
            }
            if (value2 instanceof Injector) {
                ((Injector)value2).write(thLink);
            } else {
                thLink.addText((Object)value2);
            }
            if (!columnSortable || !this.config.isEmbeddedIcons() || (img = this.config.getInnerSortableImageToStream(col.getDirection())) == null) continue;
            thLink.addImage(img, (CharSequence)col.getDirection().toString(), new CharSequence[0]);
        }
        try (Element tBody = table.addElement("tbody");){
            boolean hasRenderer = WebUtils.isType(Column.class, this.columns.stream().map(t -> t.getColumn()));
            resource.apply(this).forEach(value -> {
                Element rowElement = tBody.addElement("tr");
                for (ColumnModel<D, ?> col : this.columns) {
                    Function<D, ?> attribute = col.getColumn();
                    Element td = rowElement.addElement("td");
                    if (hasRenderer && attribute instanceof Column) {
                        ((Column)attribute).write(td, value);
                        continue;
                    }
                    td.addText(attribute.apply(value));
                }
            });
        }
    }

    public final boolean isSortable() {
        if (this.isSortable == null) {
            this.isSortable = this.isSortableCalculated();
        }
        return this.isSortable;
    }

    public boolean isSortableCalculated() {
        for (ColumnModel<D, ?> column : this.columns) {
            if (!column.isSortable()) continue;
            return true;
        }
        return false;
    }

    public Stream<ColumnModel<D, ?>> getColumns() {
        return this.columns.stream();
    }
}

