/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.report;

import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.report.ReportBuilderConfigImpl;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.GridBuilderConfig;
import org.ujorm.tools.xml.config.HtmlConfig;

public interface ReportBuilderConfig<D>
extends GridBuilderConfig<D> {
    @Override
    @Nonnull
    public HtmlConfig getConfig();

    @Override
    @Nonnull
    public String getCssLink();

    @Override
    @Nonnull
    public String getJavascriptLink();

    @Override
    @Nonnull
    public Duration getIdleDelay();

    @Override
    @Nonnull
    public HttpParameter getAjaxRequestParam();

    @Override
    @Nonnull
    public HttpParameter getSortRequestParam();

    @Override
    @Nonnull
    public CharSequence getAjaxReadyMessage();

    @Override
    @Nonnull
    public String getFormId();

    @Override
    @Nonnull
    public String getControlCss();

    @Override
    @Nonnull
    public String getSubtitleCss();

    @Override
    @Nonnull
    public CharSequence getTableSelector();

    @Override
    @Nonnull
    public List<CharSequence> getTableCssClass();

    @Override
    @Nonnull
    public CharSequence getSortable();

    @Override
    @Nonnull
    public CharSequence getSortableAsc();

    @Override
    @Nonnull
    public CharSequence getSortableDesc();

    @Override
    @Nonnull
    public CharSequence getSortableBoth();

    @Override
    public boolean isEmbeddedIcons();

    @Override
    public BiConsumer<Element, Boolean> getCssWriter();

    @Override
    @Nonnull
    default public CharSequence getSortableDirection(@Nonnull Direction direction) {
        switch (direction) {
            case ASC: {
                return this.getSortableAsc();
            }
            case DESC: {
                return this.getSortableDesc();
            }
            case NONE: {
                return this.getSortableBoth();
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @Override
    @Nullable
    default public InputStream getInnerSortableImageToStream(@Nonnull Direction direction) {
        return this.getClass().getResourceAsStream(this.getInnerSortableImage(direction));
    }

    @Override
    @Nonnull
    default public String getInnerSortableImage(@Nonnull Direction direction) {
        String baseDir = "/META-INF/resources/org/ujorm/images/v1/order";
        switch (direction) {
            case ASC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "up.png");
            }
            case DESC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "down.png");
            }
            case NONE: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "both.png");
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @Nonnull
    public static ReportBuilderConfigImpl of(@Nonnull HtmlConfig config) {
        return new ReportBuilderConfigImpl(config);
    }
}

