/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.report;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.report.ReportBuilderConfig;
import org.ujorm.tools.xml.config.HtmlConfig;

public class ReportBuilderConfigImpl<D>
implements ReportBuilderConfig<D> {
    private static final Logger LOGGER = Logger.getLogger(ReportBuilderConfigImpl.class.getName());
    @Nonnull
    protected final HtmlConfig config;
    @Nonnull
    private String cssLink;
    @Nonnull
    private String jqueryLink;
    @Nonnull
    private Duration idleDelay;
    @Nonnull
    private HttpParameter ajaxRequestParam;
    @Nonnull
    private HttpParameter sortRequestParam;
    @Nonnull
    private CharSequence ajaxReadyMessage = "AJAX ready";
    @Nonnull
    private String formId;
    @Nonnull
    private String controlCss;
    @Nonnull
    private String subtitleCss;
    @Nonnull
    private CharSequence tableSelector;
    @Nonnull
    private List<CharSequence> tableCssClass;
    @Nonnull
    private CharSequence sortableColumn;
    @Nonnull
    private CharSequence sortableAsc;
    @Nonnull
    private CharSequence sortableDesc;
    @Nonnull
    private CharSequence sortableBoth;
    private boolean embeddedIcons;
    @Nullable
    private BiConsumer<Element, Boolean> cssWriter;

    public ReportBuilderConfigImpl(@Nonnull HtmlConfig config) {
        this(config, "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css", "", Constants.IDLE_DELAY, JavaScriptWriter.DEFAULT_AJAX_REQUEST_PARAM, JavaScriptWriter.DEFAULT_SORT_REQUEST_PARAM, "form", "form-control", "subtitle", Constants.TABLE_CSS_CLASS, "sortable", "asc", "desc", "both", false, null);
    }

    protected ReportBuilderConfigImpl(@Nonnull HtmlConfig config, @Nonnull String cssLink, @Nonnull String jqueryLink, @Nonnull Duration idleDelay, @Nonnull HttpParameter ajaxRequestParam, @Nonnull HttpParameter sortRequestParam, @Nonnull String formId, @Nonnull String controlCss, @Nonnull String subtitleCss, @Nonnull List<CharSequence> tableCssClass, @Nonnull String sortableColumn, @Nonnull String sortableAsc, @Nonnull String sortableDesc, @Nonnull String sortableBoth, boolean embeddedIcons, @Nonnull BiConsumer<Element, Boolean> cssWriter) {
        this.config = config;
        this.cssLink = cssLink;
        this.jqueryLink = jqueryLink;
        this.idleDelay = idleDelay;
        this.ajaxRequestParam = ajaxRequestParam;
        this.sortRequestParam = sortRequestParam;
        this.formId = formId;
        this.controlCss = controlCss;
        this.subtitleCss = subtitleCss;
        this.tableCssClass = tableCssClass;
        this.sortableColumn = sortableColumn;
        this.sortableAsc = sortableAsc;
        this.sortableDesc = sortableDesc;
        this.sortableBoth = sortableBoth;
        this.embeddedIcons = embeddedIcons;
        this.cssWriter = cssWriter;
    }

    @Nonnull
    protected CharSequence getTableClassSelector() {
        return this.tableCssClass.isEmpty() ? "table" : String.join((CharSequence)" .", "table", this.tableCssClass.get(0));
    }

    public ReportBuilderConfigImpl<D> setCssLink(@Nonnull String cssLink) {
        this.cssLink = (String)Assert.notNull((Object)cssLink, (Object[])new String[]{"cssLink"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setJqueryLink(@Nonnull String jqueryLink) {
        this.jqueryLink = (String)Assert.notNull((Object)jqueryLink, (Object[])new String[]{"jqueryLink"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setIdleDelay(@Nonnull Duration idleDelay) {
        this.idleDelay = (Duration)Assert.notNull((Object)idleDelay, (Object[])new String[]{"idleDelay"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setAjaxRequestParam(@Nonnull HttpParameter ajaxRequestParam) {
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setSortRequestParam(@Nonnull HttpParameter sortRequestParam) {
        this.sortRequestParam = (HttpParameter)Assert.notNull((Object)sortRequestParam, (Object[])new String[]{"sortRequestParam"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setAjaxReadyMessage(@Nonnull CharSequence ajaxReadyMessage) {
        this.ajaxReadyMessage = Assert.hasLength((CharSequence)ajaxReadyMessage, (Object[])new String[]{"ajaxReadyMessage"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setFormId(@Nonnull String formId) {
        this.formId = (String)Assert.hasLength((CharSequence)formId, (Object[])new String[]{"formId"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setControlCss(@Nonnull String controlCss) {
        this.controlCss = (String)Assert.hasLength((CharSequence)controlCss, (Object[])new String[]{"controlCss"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setSubtitleCss(@Nonnull String subtitleCss) {
        this.subtitleCss = (String)Assert.hasLength((CharSequence)subtitleCss, (Object[])new String[]{"subtitleCss"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setTableSelector(@Nonnull CharSequence tableSelector) {
        this.tableSelector = (CharSequence)Assert.notNull((Object)tableSelector, (Object[])new String[]{"tableSelector"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setTableCssClass(@Nonnull List<CharSequence> tableCssClass) {
        this.tableCssClass = (List)Assert.notNull(tableCssClass, (Object[])new String[]{"tableCssClass"});
        return this;
    }

    public ReportBuilderConfigImpl<D> setCssWriter(@Nullable BiConsumer<Element, Boolean> cssWriter) {
        this.cssWriter = cssWriter;
        return this;
    }

    public boolean setEmbeddedIcons(boolean embeddedIcons) {
        this.embeddedIcons = embeddedIcons;
        return this.embeddedIcons;
    }

    @Override
    @Nonnull
    public HtmlConfig getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public String getCssLink() {
        return this.cssLink;
    }

    @Override
    @Nonnull
    public String getJavascriptLink() {
        return this.jqueryLink;
    }

    @Override
    @Nonnull
    public Duration getIdleDelay() {
        return this.idleDelay;
    }

    @Override
    @Nonnull
    public HttpParameter getAjaxRequestParam() {
        return this.ajaxRequestParam;
    }

    @Override
    @Nonnull
    public HttpParameter getSortRequestParam() {
        return this.sortRequestParam;
    }

    @Override
    @Nonnull
    public CharSequence getAjaxReadyMessage() {
        return this.ajaxReadyMessage;
    }

    @Override
    @Nonnull
    public String getFormId() {
        return this.formId;
    }

    @Override
    @Nonnull
    public String getControlCss() {
        return this.controlCss;
    }

    @Override
    @Nonnull
    public String getSubtitleCss() {
        return this.subtitleCss;
    }

    @Override
    @Nonnull
    public CharSequence getTableSelector() {
        return this.tableSelector != null ? this.tableSelector : this.getTableCssClass().get(0);
    }

    @Override
    @Nonnull
    public List<CharSequence> getTableCssClass() {
        return this.tableCssClass;
    }

    @Override
    @Nonnull
    public CharSequence getSortable() {
        return this.sortableColumn;
    }

    @Override
    @Nonnull
    public CharSequence getSortableAsc() {
        return this.sortableAsc;
    }

    @Override
    @Nonnull
    public CharSequence getSortableDesc() {
        return this.sortableDesc;
    }

    @Override
    @Nonnull
    public CharSequence getSortableBoth() {
        return this.sortableBoth;
    }

    @Override
    @Nonnull
    public BiConsumer<Element, Boolean> getCssWriter() {
        return this.cssWriter != null ? this.cssWriter : this.inlineCssWriter();
    }

    @Override
    public boolean isEmbeddedIcons() {
        return this.embeddedIcons;
    }

    @Nonnull
    protected BiConsumer<Element, Boolean> inlineCssWriter() {
        return (element, sortable) -> {
            ReportBuilderConfigImpl conf = this;
            CharSequence newLine = conf.getConfig().getNewLine();
            try (Element css = element.addElement("style");){
                css.addRawText(newLine, "body { margin: 10px;}");
                css.addRawText(newLine, ".", conf.getSubtitleCss(), " {font-size: 10px; color: silver;}");
                css.addRawText(newLine, "#", conf.getFormId(), " {margin-bottom: 2px;}");
                css.addRawText(newLine, "#", conf.getFormId(), " input {width: 200px;}");
                css.addRawText(newLine, ".", conf.getControlCss(), " {display: inline;}");
                css.addRawText(newLine, ".table th {background-color: #e8e8e8;}");
                css.addRawText(newLine, "button.", conf.getSortable(), " {border: none; padding: 0;background: none; font-weight: bold;}");
                if (Boolean.TRUE.equals(sortable)) {
                    if (this.isEmbeddedIcons()) {
                        css.addRawText(newLine, ".sortable img {margin-left: 6px;} ");
                    } else {
                        String img = "/org/ujorm/images/v1/order/";
                        css.addRawText(newLine, "button.", conf.getSortable(), " {background-repeat: no-repeat; background-position: right; padding-right: 14px; color: #212529;}");
                        css.addRawText(newLine, ".", conf.getSortable(), ".", conf.getSortableAsc(), " {background-image: url('", "/org/ujorm/images/v1/order/", "up", ".png')}");
                        css.addRawText(newLine, ".", conf.getSortable(), ".", conf.getSortableDesc(), " {background-image: url('", "/org/ujorm/images/v1/order/", "down", ".png')}");
                        css.addRawText(newLine, ".", conf.getSortable(), ".", conf.getSortableBoth(), " {background-image: url('", "/org/ujorm/images/v1/order/", "both", ".png')}");
                    }
                }
            }
        };
    }

    public static class Constants {
        public static final String BOOTSTRAP_CSS = "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css";
        public static final String FORM_ID = "form";
        public static final String CONTROL_CSS = "form-control";
        public static final String SUBTITLE_CSS = "subtitle";
        public static List<CharSequence> TABLE_CSS_CLASS = Arrays.asList("table", "table-striped", "table-bordered");
        public static final Duration IDLE_DELAY = Duration.ofMillis(250L);
    }
}

