/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.report.ReportBuilderConfigImpl;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.xml.config.HtmlConfig;

public interface GridBuilderConfig<D> {
    @NotNull
    public HtmlConfig getConfig();

    @NotNull
    public String getCssLink();

    @NotNull
    public String getJavascriptLink();

    @NotNull
    public Duration getIdleDelay();

    @NotNull
    public HttpParameter getAjaxRequestParam();

    @NotNull
    public HttpParameter getSortRequestParam();

    @NotNull
    public CharSequence getAjaxReadyMessage();

    @NotNull
    public String getFormId();

    @NotNull
    public String getControlCss();

    @NotNull
    public String getSubtitleCss();

    @NotNull
    public CharSequence getTableSelector();

    @NotNull
    public List<CharSequence> getTableCssClass();

    @NotNull
    public CharSequence getSortable();

    @NotNull
    public CharSequence getSortableAsc();

    @NotNull
    public CharSequence getSortableDesc();

    @NotNull
    public CharSequence getSortableBoth();

    public boolean isEmbeddedIcons();

    public BiConsumer<Element, Boolean> getCssWriter();

    @NotNull
    default public CharSequence getSortableDirection(@NotNull Direction direction) {
        switch (direction) {
            case ASC: {
                return this.getSortableAsc();
            }
            case DESC: {
                return this.getSortableDesc();
            }
            case NONE: {
                return this.getSortableBoth();
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @Nullable
    default public InputStream getInnerSortableImageToStream(@NotNull Direction direction) {
        return this.getClass().getResourceAsStream(this.getInnerSortableImage(direction));
    }

    @NotNull
    default public String getInnerSortableImage(@NotNull Direction direction) {
        String baseDir = "/META-INF/resources/org/ujorm/images/v1/order";
        switch (direction) {
            case ASC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "up.png");
            }
            case DESC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "down.png");
            }
            case NONE: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "both.png");
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @NotNull
    public static GridBuilderConfig of(@NotNull HtmlConfig config) {
        return new ReportBuilderConfigImpl(config);
    }
}

