/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;

public final class ExceptionProvider {
    @NotNull
    private static final ExceptionProvider EMPTY = new ExceptionProvider(null);
    @Nullable
    private final Throwable e;

    private ExceptionProvider(@Nullable Throwable e) {
        this.e = e;
    }

    public void catche(@NotNull Consumer<Throwable> exceptionConsumer) {
        this.catche(Throwable.class, exceptionConsumer);
    }

    public <T extends Throwable> void catche(@NotNull Class<T> exceptionClass, @NotNull Consumer<T> exceptionConsumer) {
        if (this.e != null) {
            if (exceptionClass.isInstance(this.e)) {
                exceptionConsumer.accept(this.e);
            } else {
                if (this.e instanceof RuntimeException) {
                    throw (RuntimeException)this.e;
                }
                if (this.e instanceof Error) {
                    throw (Error)this.e;
                }
                throw new IllegalStateException(this.e);
            }
        }
    }

    @NotNull
    public static final ExceptionProvider of(@NotNull Throwable e) {
        return new ExceptionProvider((Throwable)Assert.notNull((Object)e, (Object[])new String[]{"Exception is required"}));
    }

    @NotNull
    public static final ExceptionProvider of() {
        return EMPTY;
    }
}

