/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.IOConsumer;
import org.ujorm.tools.web.ao.IOElement;
import org.ujorm.tools.web.ao.IORunnable;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.xml.config.HtmlConfig;

public class ReqestDispatcher {
    private static final Logger LOGGER = Logger.getLogger(ReqestDispatcher.class.getName());
    @NotNull
    private final HttpServletRequest input;
    @NotNull
    private final HttpServletResponse output;
    @NotNull
    private HtmlConfig htmlConfig;
    private boolean done = false;
    private final boolean noCache = true;

    public ReqestDispatcher(@NotNull HttpServletRequest input, @NotNull HttpServletResponse output) {
        this("Info", input, output);
    }

    public ReqestDispatcher(@NotNull CharSequence title, @NotNull HttpServletRequest input, @NotNull HttpServletResponse output) {
        this(input, output, (HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public ReqestDispatcher(@NotNull HttpServletRequest input, @NotNull HttpServletResponse output, @NotNull HtmlConfig htmlConfig) {
        this.input = input;
        this.output = output;
        this.htmlConfig = htmlConfig;
        try {
            String charset = htmlConfig.getCharset().toString();
            input.setCharacterEncoding(charset);
            output.setCharacterEncoding(charset);
            output.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            output.setHeader("Pragma", "no-cache");
            output.setHeader("Expires", "0");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @NotNull
    public HtmlConfig getAjaxConfig() {
        return this.htmlConfig.cloneForAjax();
    }

    public ReqestDispatcher onParam(@NotNull HttpParameter key, @NotNull IOConsumer<JsonBuilder> processor) throws IOException, ServletException {
        Assert.notNull((Object)key, (Object[])new String[]{"Parameter {} is required", "key"});
        if (!this.done && key.of((ServletRequest)this.input, false)) {
            try (JsonBuilder builder = JsonBuilder.of(this.input, this.output, this.getAjaxConfig());){
                this.done = true;
                processor.accept(builder);
            }
        }
        return this;
    }

    public void onDefaultToElement(@NotNull IOElement defaultProcessor) throws ServletException, IOException {
        if (!this.done) {
            try (HtmlElement html = HtmlElement.of(this.htmlConfig, this.output.getWriter());){
                defaultProcessor.run(html);
            }
        }
    }

    public void onDefault(@NotNull IORunnable defaultProcessor) throws ServletException, IOException {
        if (!this.done) {
            defaultProcessor.run();
        }
    }
}

