/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ao;

import java.util.function.Function;
import javax.servlet.ServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.ao.DefaultHttpParam;

public interface HttpParameter
extends CharSequence {
    @Override
    @NotNull
    public String toString();

    @Override
    default public int length() {
        return this.toString().length();
    }

    @Override
    default public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    default public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @NotNull
    default public String defaultValue() {
        return "";
    }

    @NotNull
    default public String of(@NotNull ServletRequest request) {
        return this.of(request, (String)Assert.notNull((Object)this.defaultValue(), (Object[])new String[]{"Default value is required"}));
    }

    @NotNull
    default public String of(@NotNull ServletRequest request, @NotNull String defaultValue) {
        Object[] result = request.getParameterValues(this.toString());
        return Check.hasLength((Object[])result) ? result[result.length - 1] : defaultValue;
    }

    default public boolean of(@NotNull ServletRequest request, @Nullable boolean defaultValue) {
        switch (this.of(request)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return defaultValue;
    }

    default public char of(@NotNull ServletRequest request, @Nullable char defaultValue) {
        String value = this.of(request);
        return value.isEmpty() ? defaultValue : value.charAt(0);
    }

    default public short of(@NotNull ServletRequest request, @Nullable short defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public int of(@NotNull ServletRequest request, @Nullable int defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public long of(@NotNull ServletRequest request, @Nullable long defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public float of(@NotNull ServletRequest request, @Nullable float defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public double of(@NotNull ServletRequest request, @Nullable double defaultValue) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public <V> V of(@NotNull ServletRequest request, @NotNull V defaultValue, @NotNull Function<String, V> decoder) {
        String value = this.of(request);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return decoder.apply(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static HttpParameter of(@NotNull String name) {
        return new DefaultHttpParam(name, "");
    }

    public static HttpParameter of(@NotNull String name, @NotNull String defaultValue) {
        return new DefaultHttpParam(name, defaultValue);
    }
}

