/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.json;

import java.io.Closeable;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ao.ObjectProvider;
import org.ujorm.tools.web.json.JsonWriter;
import org.ujorm.tools.web.json.ValueProvider;
import org.ujorm.tools.xml.config.HtmlConfig;

public class JsonBuilder
implements Closeable {
    private static final char DOUBLE_QUOTE = '\"';
    @NotNull
    private final Appendable writer;
    @NotNull
    private final JsonWriter jsonWriter;
    private final HtmlConfig config;
    private int paramCounter = 0;
    private final String JAVACRIPT_DUMMY_SELECTOR = "";

    protected JsonBuilder(@NotNull Appendable writer) {
        this(writer, (HtmlConfig)HtmlConfig.ofEmptyElement());
    }

    protected JsonBuilder(@NotNull Appendable writer, HtmlConfig config) {
        this.writer = writer;
        this.jsonWriter = new JsonWriter(writer);
        this.config = config;
    }

    public JsonBuilder writeId(@NotNull CharSequence elementId, CharSequence ... values) throws IOException {
        this.writePrefix(SelectorType.ID.prefix, elementId, values);
        return this;
    }

    public JsonBuilder writeClass(@NotNull CharSequence elementId, CharSequence ... values) throws IOException {
        this.writePrefix(SelectorType.CLASS.prefix, elementId, values);
        return this;
    }

    public JsonBuilder write(@NotNull CharSequence key, CharSequence ... values) throws IOException {
        this.writePrefix(SelectorType.INCLUDED.prefix, key, values);
        return this;
    }

    public JsonBuilder writePrefix(@NotNull String keyPrefix, @NotNull CharSequence key, CharSequence ... values) throws IOException {
        this.writeKey(keyPrefix, key);
        if (values == null) {
            this.writer.append("null");
        } else {
            this.writer.append('\"');
            for (CharSequence value : values) {
                this.jsonWriter.append(value);
            }
        }
        this.writer.append('\"');
        return this;
    }

    public JsonBuilder writeJs(CharSequence ... javascript) throws IOException {
        return this.write((CharSequence)"", javascript);
    }

    private void writeKey(String keyPrefix, CharSequence key) throws IOException {
        this.writer.append(this.paramCounter++ == 0 ? (char)'{' : ',');
        this.writer.append('\"');
        this.jsonWriter.append(keyPrefix);
        this.jsonWriter.append(key);
        this.writer.append('\"');
        this.writer.append(':');
    }

    public JsonBuilder writeId(@NotNull CharSequence elementId, @NotNull ValueProvider valueProvider) throws IOException {
        return this.write(SelectorType.ID.prefix, elementId, valueProvider);
    }

    public JsonBuilder writeClass(@NotNull CharSequence elementId, @NotNull ValueProvider valueProvider) throws IOException {
        return this.write(SelectorType.CLASS.prefix, elementId, valueProvider);
    }

    public JsonBuilder write(@NotNull CharSequence key, @NotNull ValueProvider valueProvider) throws IOException {
        return this.write(SelectorType.INCLUDED.prefix, key, valueProvider);
    }

    public JsonBuilder write(@NotNull String keyPrefix, @NotNull CharSequence key, @NotNull ValueProvider valueProvider) throws IOException {
        this.writeKey(keyPrefix, key);
        this.writer.append('\"');
        try (HtmlElement root = HtmlElement.of(this.config, this.jsonWriter);){
            valueProvider.accept(root.original());
        }
        this.writer.append('\"');
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.paramCounter == 0) {
            this.writer.append('{');
        }
        this.writer.append('}');
    }

    public JsonBuilder writeIdObj(@NotNull CharSequence elementId, @NotNull ObjectProvider objectProvider) throws IOException {
        return this.writeObj(SelectorType.ID.prefix, elementId, objectProvider);
    }

    public JsonBuilder writeClassObj(@NotNull CharSequence elementId, @NotNull ObjectProvider objectProvider) throws IOException {
        return this.writeObj(SelectorType.CLASS.prefix, elementId, objectProvider);
    }

    public JsonBuilder writeObj(@NotNull CharSequence key, @NotNull ObjectProvider objectProvider) throws IOException {
        return this.writeObj(SelectorType.INCLUDED.prefix, key, objectProvider);
    }

    public JsonBuilder writeObj(@NotNull String keyPrefix, @NotNull CharSequence key, @NotNull ObjectProvider objectProvider) throws IOException {
        this.writeKey(keyPrefix, key);
        objectProvider.accept(this);
        this.writer.append('\"');
        return this;
    }

    @NotNull
    public static final JsonBuilder of(@NotNull Appendable writer) {
        return new JsonBuilder(writer);
    }

    @NotNull
    public static final JsonBuilder of(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) throws IllegalStateException, IOException {
        return JsonBuilder.of((HtmlConfig)HtmlConfig.ofEmptyElement(), request, response);
    }

    @NotNull
    public static final JsonBuilder of(@NotNull HtmlConfig config, @NotNull HttpServletResponse response) throws IllegalStateException, IOException {
        return JsonBuilder.of(null, response, config);
    }

    @Deprecated
    @NotNull
    public static final JsonBuilder of(@Nullable HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull HtmlConfig config) throws IllegalStateException, IOException {
        return JsonBuilder.of(config, request, response);
    }

    @NotNull
    public static final JsonBuilder of(@NotNull HtmlConfig config, @Nullable HttpServletRequest request, @NotNull HttpServletResponse response) throws IllegalStateException, IOException {
        if (config.isHtmlHeaderRequest()) {
            response.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Expires", "0");
        }
        String charset = config.getCharset().toString();
        response.setCharacterEncoding(charset);
        if (request != null) {
            request.setCharacterEncoding(charset);
        }
        return new JsonBuilder(response.getWriter(), config);
    }

    public static enum SelectorType {
        ID("#"),
        CLASS("."),
        INCLUDED("");

        final String prefix;

        private SelectorType(String prefix) {
            this.prefix = prefix;
        }

        @NotNull
        public String getPrefix() {
            return this.prefix;
        }
    }
}

