/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.report;

import java.io.InputStream;
import java.time.Duration;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.report.ReportBuilderConfigImpl;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.GridBuilderConfig;
import org.ujorm.tools.xml.config.HtmlConfig;

public interface ReportBuilderConfig<D>
extends GridBuilderConfig<D> {
    @Override
    @NotNull
    public HtmlConfig getConfig();

    @Override
    @NotNull
    public String getCssLink();

    @Override
    @NotNull
    public String getJavascriptLink();

    @Override
    @NotNull
    public Duration getIdleDelay();

    @Override
    @NotNull
    public HttpParameter getAjaxRequestParam();

    @Override
    @NotNull
    public HttpParameter getSortRequestParam();

    @Override
    @NotNull
    public CharSequence getAjaxReadyMessage();

    @Override
    @NotNull
    public String getFormId();

    @Override
    @NotNull
    public String getControlCss();

    @Override
    @NotNull
    public String getSubtitleCss();

    @Override
    @NotNull
    public CharSequence getTableSelector();

    @Override
    @NotNull
    public List<CharSequence> getTableCssClass();

    @Override
    @NotNull
    public CharSequence getSortable();

    @Override
    @NotNull
    public CharSequence getSortableAsc();

    @Override
    @NotNull
    public CharSequence getSortableDesc();

    @Override
    @NotNull
    public CharSequence getSortableBoth();

    @Override
    public boolean isEmbeddedIcons();

    @Override
    public BiConsumer<Element, Boolean> getCssWriter();

    @Override
    @NotNull
    default public CharSequence getSortableDirection(@NotNull Direction direction) {
        switch (direction) {
            case ASC: {
                return this.getSortableAsc();
            }
            case DESC: {
                return this.getSortableDesc();
            }
            case NONE: {
                return this.getSortableBoth();
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @Override
    @Nullable
    default public InputStream getInnerSortableImageToStream(@NotNull Direction direction) {
        return this.getClass().getResourceAsStream(this.getInnerSortableImage(direction));
    }

    @Override
    @NotNull
    default public String getInnerSortableImage(@NotNull Direction direction) {
        String baseDir = "/META-INF/resources/org/ujorm/images/v1/order";
        switch (direction) {
            case ASC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "up.png");
            }
            case DESC: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "down.png");
            }
            case NONE: {
                return String.join((CharSequence)"/", "/META-INF/resources/org/ujorm/images/v1/order", "both.png");
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)direction));
    }

    @NotNull
    public static ReportBuilderConfigImpl of(@NotNull HtmlConfig config) {
        return new ReportBuilderConfigImpl(config);
    }
}

