/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;

public class JavaScriptWriter
implements Injector {
    public static final HttpParameter DEFAULT_AJAX_REQUEST_PARAM = HttpParameter.of("_ajax");
    public static final HttpParameter DEFAULT_SORT_REQUEST_PARAM = HttpParameter.of("_sort");
    public static final Duration DEFAULT_DELAY = Duration.ofMillis(250L);
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    protected final HttpParameter ajaxRequestParam;
    protected final HttpParameter sortRequestParam;
    protected final CharSequence[] inputCssSelectors;
    @NotNull
    protected Duration idleDelay = DEFAULT_DELAY;
    @NotNull
    protected Duration ajaxTimeout = DEFAULT_TIMEOUT;
    protected String formSelector = "form";
    protected boolean onLoadSubmit = false;
    protected CharSequence newLine = "\n";
    @Nullable
    protected CharSequence subtitleSelector = "?";
    @NotNull
    protected CharSequence errorMessage = "AJAX fails due";
    protected int version = 1;
    protected String ajaxRequestPath = "_ajax";
    protected int fceOrder = 1;
    protected boolean isAjax = true;

    public JavaScriptWriter() {
        this("form input:not([type=\"button\"])");
    }

    public JavaScriptWriter(CharSequence ... inputSelectors) {
        this(DEFAULT_DELAY, DEFAULT_AJAX_REQUEST_PARAM, DEFAULT_SORT_REQUEST_PARAM, inputSelectors);
    }

    public JavaScriptWriter(@NotNull Duration idleDelay, @NotNull HttpParameter ajaxRequestParam, @NotNull HttpParameter sortRequestParam, CharSequence ... inputSelectors) {
        this.idleDelay = (Duration)Assert.notNull((Object)idleDelay, (Object[])new String[]{"idleDelay"});
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        this.sortRequestParam = (HttpParameter)Assert.notNull((Object)sortRequestParam, (Object[])new String[]{"sortRequestParam"});
        this.inputCssSelectors = (CharSequence[])Assert.hasLength((Object[])inputSelectors, (Object[])new String[]{"inputSelectors"});
    }

    public JavaScriptWriter setFormSelector(String formSelector) {
        this.formSelector = (String)Assert.notNull((Object)formSelector, (Object[])new String[]{"formSelector"});
        return this;
    }

    public JavaScriptWriter setOnLoadSubmit(boolean onLoadSubmit) {
        this.onLoadSubmit = onLoadSubmit;
        return this;
    }

    public JavaScriptWriter setNewLine(@NotNull CharSequence newLine) {
        this.newLine = (CharSequence)Assert.notNull((Object)newLine, (Object[])new String[]{"newLine"});
        return this;
    }

    public JavaScriptWriter setSubtitleSelector(CharSequence subtitleSelector) {
        this.subtitleSelector = subtitleSelector;
        return this;
    }

    public JavaScriptWriter setErrorMessage(@Nullable CharSequence errorMessage) {
        this.errorMessage = Assert.hasLength((CharSequence)errorMessage, (Object[])new String[]{"errorMessage"});
        return this;
    }

    public JavaScriptWriter setAjaxTimeout(@NotNull Duration ajaxTimeout) {
        this.ajaxTimeout = (Duration)Assert.notNull((Object)ajaxTimeout, (Object[])new String[]{"ajaxTimeout"});
        return this;
    }

    public JavaScriptWriter setIdleDelay(@NotNull Duration idleDelay) {
        this.idleDelay = (Duration)Assert.notNull((Object)idleDelay, (Object[])new String[]{"idleDelay"});
        return this;
    }

    public JavaScriptWriter setAjaxRequestPath(@NotNull String ajaxRequestPath) {
        this.ajaxRequestPath = ajaxRequestPath;
        this.setVersion(2);
        return this;
    }

    public JavaScriptWriter setVersion(int version) {
        this.version = version;
        return this;
    }

    public JavaScriptWriter setSortable(int fceOrder) {
        this.fceOrder = fceOrder;
        return this;
    }

    public int getFceOrder() {
        return this.fceOrder;
    }

    public JavaScriptWriter setAjax(boolean ajax) {
        this.isAjax = ajax;
        return this;
    }

    public boolean isAjax() {
        return this.isAjax;
    }

    @Override
    public void write(@NotNull Element parent) {
        String inpSelectors = Check.hasLength((Object[])this.inputCssSelectors) ? Stream.of(this.inputCssSelectors).collect(Collectors.joining(", ")) : "#!@";
        try (Element js = parent.addElement("script");){
            js.addRawText(this.newLine, "/* Script of ujorm.org *//* jshint esversion:6 */");
            if (this.isAjax) {
                js.addRawText(this.newLine, "const f", this.fceOrder, "={");
                js.addRawTexts(this.newLine, "", "ajaxRun:false, submitReq:false, delayMs:" + this.idleDelay.toMillis() + ", timeout:null,", "init(e){", " document.querySelector('" + this.formSelector + "').addEventListener('submit',this.process,false);", " document.querySelectorAll('" + inpSelectors + "').forEach(i=>{", "  i.addEventListener('keyup',e=>this.timeEvent(e),false);", " });},");
                js.addRawTexts(this.newLine, "", "timeEvent(e){", " if(this.timeout)clearTimeout(this.timeout);", " this.timeout=setTimeout(()=>{", "  this.timeout=null;", "  if(this.ajaxRun)this.submitReq=true;", "  else this.process(null);", " },this.delayMs);},");
                js.addRawTexts(this.newLine, "", "process(e){", " let pars=new URLSearchParams(new FormData(document.querySelector('" + this.formSelector + "')));", " if(e!==null){e.preventDefault();pars.append(e.submitter.name,e.submitter.value);}", " fetch('" + (this.version == 2 ? this.ajaxRequestPath : "?" + this.ajaxRequestPath + "=true") + "', {", "   method:'POST',", "   body:pars,", "   headers:{'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8'},", " })", " .then(response=>response.json())", " .then(data=>{", "   for(const key of Object.keys(data))", "    if(key=='')eval(data[key]);", "    else document.querySelectorAll(key).forEach(i=>{i.innerHTML=data[key];});", "   if(this.submitReq){this.submitReq=false;this.process(e);}", "   else{this.ajaxRun=false;}", " }).catch(err=>{", "   this.ajaxRun=false;", "    document.querySelector('" + this.subtitleSelector + "').innerHTML='" + this.errorMessage + ": ' + err;", " });", "}");
                js.addRawTexts(this.newLine, "};");
                js.addRawText(this.newLine, "document.addEventListener('DOMContentLoaded',e=>f", this.fceOrder, ".init(e));");
                if (this.onLoadSubmit) {
                    js.addRawText(this.newLine, "f", this.fceOrder, ".process(null);");
                }
            }
        }
    }
}

