/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.json;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.ujorm.tools.Assert;

public final class JsonWriter
implements Appendable {
    private static final char BACKSLASH = '\\';
    static final char DOUBLE_QUOTE = '\"';
    private final Appendable writer;

    JsonWriter(@NotNull Appendable writer) {
        this.writer = (Appendable)Assert.notNull((Object)writer, (Object[])new String[]{"writer"});
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(@NotNull CharSequence csq, int start, int end) throws IOException {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        switch (c) {
            case '\\': {
                this.writer.append('\\');
                this.writer.append('\\');
                break;
            }
            case '\"': {
                this.writer.append('\\');
                this.writer.append('\"');
                break;
            }
            case '\b': {
                this.writer.append('\\');
                this.writer.append('b');
                break;
            }
            case '\f': {
                this.writer.append('\\');
                this.writer.append('f');
                break;
            }
            case '\n': {
                this.writer.append('\\');
                this.writer.append('n');
                break;
            }
            case '\r': {
                this.writer.append('\\');
                this.writer.append('r');
                break;
            }
            case '\t': {
                this.writer.append('\\');
                this.writer.append('t');
                break;
            }
            default: {
                this.writer.append(c);
            }
        }
        return this;
    }

    @NotNull
    public Appendable original() {
        return this.writer;
    }
}

