/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.ExceptionProvider;
import org.ujorm.tools.web.Html;
import org.ujorm.tools.web.ao.Column;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;
import org.ujorm.tools.web.ao.WebUtils;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.model.XmlModel;

public final class Element
implements ApiElement<Element>,
Html {
    final ApiElement internalElement;

    Element(@NotNull ApiElement original) {
        this.internalElement = original;
    }

    @Override
    @NotNull
    public String getName() {
        return this.internalElement.getName();
    }

    @Override
    @NotNull
    public Element setAttribute(@NotNull String name, @Nullable Object value) {
        this.internalElement.setAttribute(name, value);
        return this;
    }

    @NotNull
    public Element setAttributes(@NotNull String name, @NotNull CharSequence separator, Object ... value) {
        String val = Stream.of(value).filter(Objects::nonNull).map(v -> v.toString()).collect(Collectors.joining(separator));
        this.internalElement.setAttribute(name, val);
        return this;
    }

    @NotNull
    public Element setAttribute(@NotNull String name) {
        return this.setAttribute(name, "");
    }

    @NotNull
    public Element setAttr(@NotNull String name, @Nullable Object value) {
        return this.setAttribute(name, value);
    }

    @Override
    @NotNull
    public Element addText(Object data) throws IllegalStateException {
        this.internalElement.addText(data);
        return this;
    }

    @NotNull
    public Element addText(Object ... data) throws IllegalStateException {
        return this.addTexts("", data);
    }

    @Override
    @NotNull
    public Element addTextTemplated(CharSequence template, Object ... values) {
        this.internalElement.addTextTemplated(template, values);
        return this;
    }

    public Element addTexts(@NotNull CharSequence separator, Object ... data) throws IllegalStateException {
        int max = data.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.internalElement.addRawText(separator);
            }
            this.internalElement.addText(data[i]);
        }
        return this;
    }

    @Override
    @NotNull
    public Element addRawText(@Nullable Object data) throws IllegalStateException {
        this.internalElement.addRawText(data);
        return this;
    }

    @NotNull
    public Element addRawText(Object ... data) throws IllegalStateException {
        for (Object item : data) {
            this.internalElement.addRawText(item);
        }
        return this;
    }

    public Element addRawTexts(@NotNull CharSequence separator, Object ... data) throws IllegalStateException {
        int max = data.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.internalElement.addRawText(separator);
            }
            this.internalElement.addRawText(data[i]);
        }
        return this;
    }

    @Override
    @NotNull
    public Element addComment(CharSequence comment) throws IllegalStateException {
        this.internalElement.addComment(comment);
        return this;
    }

    @Override
    @NotNull
    public Element addCDATA(CharSequence charData) throws IllegalStateException {
        this.internalElement.addCDATA(charData);
        return this;
    }

    @Override
    @NotNull
    public void close() throws IllegalStateException {
        this.internalElement.close();
    }

    @Override
    @NotNull
    public Element addElement(@NotNull String name) throws IllegalStateException {
        return new Element((ApiElement)this.internalElement.addElement(name));
    }

    @NotNull
    public Element addElement(@NotNull String name, CharSequence ... cssClasses) {
        return this.addElement(name).setClass(cssClasses);
    }

    @NotNull
    public Element addElementIf(boolean enabled, @NotNull String name, CharSequence ... cssClasses) {
        return this.addElement(enabled ? name : XmlBuilder.HIDDEN_NAME).setClass(cssClasses);
    }

    @NotNull
    public Element addTable(CharSequence ... cssClasses) {
        return this.addElement("table", cssClasses);
    }

    @NotNull
    public Element addTable(@NotNull Object[][] data, CharSequence ... cssClass) {
        return this.addTable(Arrays.asList(data), cssClass);
    }

    @NotNull
    public Element addTable(@NotNull Collection<Object[]> data, CharSequence ... cssClass) {
        Element result = this.addTable(cssClass);
        for (Object[] rowValue : data) {
            if (rowValue == null) continue;
            Element rowElement = result.addElement("tr");
            for (Object value : rowValue) {
                rowElement.addElement("td").addText(value);
            }
        }
        return result;
    }

    @NotNull
    public <D, V> Element addTable(@NotNull Stream<D> domains, @Nullable CharSequence[] cssClass, @Nullable Object[] headers, Function<D, V> ... attributes) {
        Element result = this.addTable(cssClass != null ? cssClass : new String[]{});
        if (Check.hasLength((Object[])headers)) {
            Element rowElement = result.addElement("thead").addElement("tr");
            for (Object value2 : headers) {
                Element th = rowElement.addElement("th");
                if (value2 instanceof Injector) {
                    ((Injector)value2).write(th);
                    continue;
                }
                th.addText(value2);
            }
        }
        Element tBody = result.addElement("tbody");
        Object object = null;
        try {
            boolean hasRenderer = WebUtils.isType(Column.class, attributes);
            domains.forEach(value -> {
                Element rowElement = tBody.addElement("tr");
                for (Function attribute : attributes) {
                    Element td = rowElement.addElement("td");
                    if (hasRenderer && attribute instanceof Column) {
                        ((Column)attribute).write(td, value);
                        continue;
                    }
                    td.addText(attribute.apply(value));
                }
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tBody != null) {
                if (object != null) {
                    try {
                        tBody.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tBody.close();
                }
            }
        }
        return result;
    }

    @NotNull
    public Element addImage(@NotNull CharSequence imageLink, @NotNull CharSequence alt, CharSequence ... cssClasses) throws IllegalStateException {
        return this.addElement("img", cssClasses).setAttribute("alt", alt).setAttribute("src", imageLink);
    }

    @NotNull
    public Element addImage(@NotNull InputStream imageStream, @NotNull CharSequence alt, CharSequence ... cssClasses) throws IllegalStateException {
        return this.addElement("img", cssClasses).setAttribute("alt", alt).setAttribute("src", this.createEmbededImage(imageStream, new StringBuilder(1024)));
    }

    @NotNull
    private CharSequence createEmbededImage(@NotNull InputStream imageStream, @NotNull StringBuilder result) {
        int bufferSize = 3072;
        Base64.Encoder encoder = Base64.getEncoder();
        try (BufferedInputStream in = new BufferedInputStream(imageStream);){
            result.append("data:image/png;base64,");
            byte[] chunk = new byte[3072];
            int len = 0;
            while ((len = in.read(chunk)) == 3072) {
                result.append(encoder.encodeToString(chunk));
            }
            if (len > 0) {
                chunk = Arrays.copyOf(chunk, len);
                result.append(encoder.encodeToString(chunk));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return result;
    }

    @NotNull
    public Element addBody(CharSequence ... cssClasses) {
        return this.addElement("body", cssClasses);
    }

    @NotNull
    public Element addTitle(CharSequence ... cssClasses) {
        return this.addElement("title", cssClasses);
    }

    @NotNull
    public Element addLink(CharSequence ... cssClasses) {
        return this.addElement("link", cssClasses);
    }

    @NotNull
    public Element addStyle(CharSequence ... cssClasses) {
        return this.addElement("style", cssClasses);
    }

    @NotNull
    public Element addScript(CharSequence ... cssClasses) {
        return this.addElement("script", cssClasses);
    }

    @NotNull
    public Element addDiv(CharSequence ... cssClasses) {
        return this.addElement("div", cssClasses);
    }

    @NotNull
    public Element addFieldset(@Nullable String title, CharSequence ... cssClasses) {
        Element result = this.addElement("fieldset", cssClasses);
        if (Check.hasLength((CharSequence)title)) {
            result.addElement("legend").addText((Object)title);
        }
        return result;
    }

    @NotNull
    public Element addPreformatted(CharSequence ... cssClasses) {
        return this.addElement("pre", cssClasses);
    }

    @NotNull
    public Element addSpan(CharSequence ... cssClasses) {
        return this.addElement("span", cssClasses);
    }

    @NotNull
    public Element addParagraph(CharSequence ... cssClasses) {
        return this.addElement("p", cssClasses);
    }

    @NotNull
    public Element addForm(CharSequence ... cssClasses) {
        return this.addElement("form", cssClasses);
    }

    @NotNull
    public Element addHeading(@NotNull CharSequence title, CharSequence ... cssClasses) {
        return this.addHeading(1, title, cssClasses);
    }

    @NotNull
    public Element addHeading(int level, @NotNull CharSequence title, CharSequence ... cssClasses) {
        Assert.isTrue((level > 0 ? 1 : 0) != 0, (Object[])new Serializable[]{"Unsupported level {}", Integer.valueOf(level)});
        return this.addElement("h" + level, cssClasses).addText((Object)title);
    }

    @NotNull
    public Element addTableHead(CharSequence ... cssClasses) {
        return this.addElement("thead", cssClasses);
    }

    @NotNull
    public Element addTableRow(CharSequence ... cssClasses) {
        return this.addElement("tr", cssClasses);
    }

    @NotNull
    public Element addTableDetail(CharSequence ... cssClasses) {
        return this.addElement("td", cssClasses);
    }

    @NotNull
    public Element addLabel(CharSequence ... cssClasses) {
        return this.addElement("label", cssClasses);
    }

    @NotNull
    public Element addInput(CharSequence ... cssClasses) {
        return this.addElement("input", cssClasses);
    }

    @NotNull
    public Element addTextInput(CharSequence ... cssClasses) {
        return this.addInput(cssClasses).setType("text");
    }

    @NotNull
    public <V> Element addTextInp(@NotNull HttpParameter param, @Nullable V value, @NotNull CharSequence title, CharSequence ... cssClasses) {
        return this.addTextInput(cssClasses).setName(param).setValue(value).setAttribute("placeholder", title).setAttribute("title", title);
    }

    @NotNull
    public Element addPasswordInput(CharSequence ... cssClasses) {
        return this.addInput(cssClasses).setType("password");
    }

    @NotNull
    public Element addHiddenInput(@Nullable CharSequence name, @Nullable Object value) {
        return this.addInput(new CharSequence[0]).setType("hidden").setNameValue(name, value);
    }

    @NotNull
    public Element addTextArea(CharSequence ... cssClasses) {
        return this.addElement("textarea", cssClasses);
    }

    @NotNull
    public Element addSelect(CharSequence ... cssClasses) {
        return this.addElement("select", cssClasses);
    }

    @NotNull
    public Element addSelectOptions(@NotNull Object value, @NotNull Map<?, ?> options, CharSequence ... cssClasses) {
        for (Object key : options.keySet()) {
            this.addElement("option").setAttribute("value", key).setAttribute("selected", Objects.equals(value, key) ? "selected" : null).addText(options.get(key));
        }
        return this;
    }

    @NotNull
    public Element addOption(CharSequence ... cssClasses) {
        return this.addElement("option", cssClasses);
    }

    @NotNull
    public Element addButton(CharSequence ... cssClasses) {
        return this.addElement("button", cssClasses);
    }

    @NotNull
    public Element addSubmitButton(CharSequence ... cssClasses) {
        Element result = this.addButton(cssClasses);
        return result.setType("submit");
    }

    @NotNull
    public Element addAnchor(@NotNull String url, CharSequence ... cssClasses) {
        Element result = this.addElement("a", cssClasses);
        return result.setHref(url);
    }

    @NotNull
    public Element addLinkedText(@NotNull String url, Object ... text) {
        this.addElement("a").setHref(url).addTexts("", text);
        return this;
    }

    @NotNull
    public Element addUnorderedlist(CharSequence ... cssClasses) {
        return this.addElement("ul", cssClasses);
    }

    @NotNull
    public Element addOrderedList(CharSequence ... cssClasses) {
        return this.addElement("ol", cssClasses);
    }

    @NotNull
    public Element addListItem(CharSequence ... cssClasses) {
        return this.addElement("li", cssClasses);
    }

    @NotNull
    public Element setClass(CharSequence ... cssClasses) {
        if (Check.hasLength((Object[])cssClasses)) {
            StringJoiner builder = new StringJoiner(" ");
            for (CharSequence cssClass : cssClasses) {
                if (!Check.hasLength((CharSequence)cssClass)) continue;
                builder.add(cssClass);
            }
            String result = builder.toString();
            if (Check.hasLength((CharSequence)result)) {
                this.setAttribute("class", result);
            }
        }
        return this;
    }

    @NotNull
    public Element addBreak(CharSequence ... cssClasses) {
        return this.addElement("br", cssClasses);
    }

    @NotNull
    public static Element createHtmlRoot(@NotNull Object title, CharSequence ... cssLinks) {
        return Element.createHtmlRoot(title, null, cssLinks);
    }

    @NotNull
    public static Element createHtmlRoot(@NotNull Object title, @Nullable Charset charset, CharSequence ... cssLinks) {
        XmlModel result = new XmlModel("html");
        XmlModel head = result.addElement("head");
        head.addElement("meta").setAttribute("charset", charset);
        head.addElement("title").addText(title);
        if (cssLinks != null) {
            for (CharSequence cssLink : cssLinks) {
                head.addElement("link").setAttribute("href", cssLink).setAttribute("rel", "stylesheet");
            }
        }
        return new Element(result);
    }

    @NotNull
    public Element setId(@Nullable CharSequence value) {
        this.setAttribute("id", value);
        return this;
    }

    @NotNull
    public Element setMethod(@Nullable Object value) {
        this.setAttribute("method", value);
        return this;
    }

    @NotNull
    public Element setAction(@Nullable Object value) {
        this.setAttribute("action", value);
        return this;
    }

    @NotNull
    public Element setType(@Nullable Object value) {
        this.setAttribute("type", value);
        return this;
    }

    @NotNull
    public Element setName(@Nullable CharSequence value) {
        this.setAttribute("name", value);
        return this;
    }

    @NotNull
    public Element setValue(@Nullable Object value) {
        this.setAttribute("value", value);
        return this;
    }

    @NotNull
    public Element setNameValue(@Nullable CharSequence name, @Nullable Object value) {
        return this.setName(name).setValue(value);
    }

    @NotNull
    public Element setFor(@Nullable CharSequence value) {
        this.setAttribute("for", value);
        return this;
    }

    @NotNull
    public Element setRows(@Nullable int value) {
        this.setAttribute("rows", value);
        return this;
    }

    @NotNull
    public Element setCols(@Nullable Object value) {
        this.setAttribute("cols", value);
        return this;
    }

    @NotNull
    public Element setColSpan(@Nullable int value) {
        this.setAttribute("colspan", value);
        return this;
    }

    @NotNull
    public Element setRowSpan(@Nullable int value) {
        this.setAttribute("cols", value);
        return this;
    }

    @NotNull
    public Element setHref(@Nullable CharSequence value) {
        this.setAttribute("href", value);
        return this;
    }

    @NotNull
    public Element setHint(@Nullable CharSequence value) {
        this.setAttribute("placeholder", value);
        return this;
    }

    @NotNull
    public ExceptionProvider then(@NotNull Consumer<Element> builder) {
        return this.next(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExceptionProvider next(@NotNull Consumer<Element> builder) {
        try {
            builder.accept(this);
            ExceptionProvider exceptionProvider = ExceptionProvider.of();
            return exceptionProvider;
        }
        catch (Throwable e) {
            ExceptionProvider exceptionProvider = ExceptionProvider.of(e);
            return exceptionProvider;
        }
        finally {
            this.close();
        }
    }

    @NotNull
    public String toString() {
        return this.internalElement.toString();
    }

    @NotNull
    public static Element of(@NotNull ApiElement original) {
        return original instanceof Element ? (Element)original : new Element(original);
    }
}

