/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ExceptionProvider;
import org.ujorm.tools.web.Html;
import org.ujorm.tools.web.request.RContext;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.builder.XmlPrinter;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;
import org.ujorm.tools.xml.model.XmlModel;
import org.ujorm.tools.xml.model.XmlWriter;

public class HtmlElement
implements ApiElement<Element>,
Html {
    @NotNull
    private final Element root;
    @NotNull
    private Element head;
    @NotNull
    private Element body;
    @NotNull
    private final HtmlConfig config;
    @NotNull
    private final Appendable writer;

    public HtmlElement(@NotNull HtmlConfig config, @NotNull Appendable writer) {
        this(new XmlModel("html"), config, writer);
    }

    public HtmlElement(@NotNull ApiElement root, @NotNull HtmlConfig config, @NotNull Appendable writer) {
        this.root = new Element(root);
        this.config = config;
        this.writer = writer;
    }

    @Override
    @NotNull
    public String getName() {
        return this.root.getName();
    }

    @Override
    public Element setAttribute(String name, Object value) {
        return this.root.setAttribute(name, value);
    }

    @Override
    public Element addText(Object value) {
        return this.root.addText(value);
    }

    @Override
    public Element addTextTemplated(@NotNull CharSequence template, Object ... values) {
        return this.root.addTextTemplated(template, values);
    }

    @Override
    public Element addRawText(Object value) {
        return this.root.addRawText(value);
    }

    @Override
    public Element addComment(CharSequence comment) {
        return this.root.addComment(comment);
    }

    @Override
    public Element addCDATA(CharSequence charData) {
        return this.root.addCDATA(charData);
    }

    @Override
    @NotNull
    public final Element addElement(@NotNull String name) throws IllegalStateException {
        switch (name) {
            case "head": {
                return this.getHead();
            }
            case "body": {
                return this.getBody();
            }
        }
        return this.root.addElement(name);
    }

    public Element getHead() {
        if (this.head == null) {
            this.head = this.root.addElement("head");
        }
        return this.head;
    }

    public Element addHead() {
        return this.getHead();
    }

    @NotNull
    public Element getBody() {
        if (this.body == null) {
            this.body = this.root.addElement("body");
        }
        return this.body;
    }

    @NotNull
    public Element addBody() {
        return this.getBody();
    }

    public void addJavascriptLinks(boolean defer, CharSequence ... javascriptLinks) {
        for (CharSequence js : javascriptLinks) {
            this.addJavascriptLink(defer, js);
        }
    }

    public Element addJavascriptLink(boolean defer, @NotNull CharSequence javascriptLink) {
        Assert.notNull((Object)javascriptLink, (Object[])new String[]{"The argument {} is required", "javascriptLink"});
        return this.getHead().addElement("script").setAttribute("src", javascriptLink).setAttribute("defer", defer ? "defer" : null);
    }

    public Element addJavascriptBody(CharSequence ... javascript) {
        if (Check.hasLength((Object[])javascript)) {
            Element result = this.getHead().addElement("script").setAttribute("language", "javascript").setAttribute("type", "text/javascript");
            int max = javascript.length;
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    result.addRawText((Object)"\n");
                }
                result.addRawText((Object)javascript[i]);
            }
            return result;
        }
        return this.head;
    }

    public void addCssLinks(CharSequence ... css) {
        for (CharSequence cssLink : css) {
            this.addCssLink(cssLink);
        }
    }

    public Element addCssLink(@NotNull CharSequence css) {
        Assert.notNull((Object)css, (Object[])new String[]{"The argument {} is required", "css"});
        return this.getHead().addElement("link").setAttribute("href", css).setAttribute("rel", "stylesheet");
    }

    public Element addCssBody(@NotNull CharSequence css) {
        Assert.notNull((Object)css, (Object[])new String[]{"The argument {} is required", "css"});
        return this.getHead().addElement("style").addRawText((Object)css);
    }

    public Element addCssBodies(@NotNull CharSequence lineSeparator, CharSequence ... css) {
        Assert.hasLength((Object[])css, (Object[])new String[]{"The argument {} is required", "css"});
        Element result = this.getHead().addElement("style");
        int max = css.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                result.addRawText((Object)lineSeparator);
            }
            result.addRawText((Object)css[i]);
        }
        return result;
    }

    @NotNull
    public Element original() {
        return this.root;
    }

    @NotNull
    public String toString() throws IllegalStateException {
        return this.writer.toString();
    }

    @Override
    public void close() throws IllegalStateException {
        this.root.close();
        if (this.root.internalElement instanceof XmlModel) {
            XmlModel xmlElement = (XmlModel)this.root.internalElement;
            try {
                CharSequence doctype = this.config.getDoctype();
                XmlWriter xmlWriter = new XmlWriter(this.writer.append(doctype).append(doctype.length() == 0 ? "" : this.config.getNewLine()), this.config.getIndentation());
                xmlElement.toWriter(this.config.getFirstLevel() + 1, xmlWriter);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @NotNull
    public HtmlConfig getConfig() {
        return this.config;
    }

    public CharSequence getTitle() {
        return this.getConfig().getTitle();
    }

    @NotNull
    public static HtmlElement of(@NotNull Appendable writer, @NotNull HtmlConfig myConfig) throws IllegalStateException {
        HtmlConfig config = myConfig != null ? myConfig : new DefaultHtmlConfig();
        ApiElement<XmlModel> root = config.isDocumentObjectModel() ? new XmlModel(config.getRootElementName()) : new XmlBuilder(config.getRootElementName(), new XmlPrinter(writer, config), config.getFirstLevel());
        HtmlElement result = new HtmlElement(root, config, writer);
        if (config.isHtmlHeaderRequest()) {
            config.getLanguage().ifPresent(lang -> result.setAttribute("lang", lang));
            result.getHead().addElement("meta").setAttribute("charset", config.getCharset());
            result.getHead().addElement("title").addText((Object)config.getTitle());
            result.addCssLinks(config.getCssLinks());
            config.getHeaderInjector().write(result.getHead());
            CharSequence rawHeaderText = config.getRawHeaderText();
            if (Check.hasLength((CharSequence)rawHeaderText)) {
                result.getHead().addRawText((Object)config.getNewLine());
                result.getHead().addRawText((Object)rawHeaderText);
            }
        }
        return result;
    }

    @NotNull
    public static HtmlElement of(@NotNull RContext context, @NotNull HtmlConfig myConfig) {
        return HtmlElement.of(context.writer(), myConfig);
    }

    @NotNull
    public static HtmlElement ofServlet(@NotNull Object htmlServletResponse, @Nullable HtmlConfig config) {
        return HtmlElement.of(RContext.ofServlet(null, htmlServletResponse).writer(), config);
    }

    @NotNull
    public static HtmlElement ofServlet(@NotNull String title, @NotNull Object htmlServletResponse, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(RContext.ofServlet(null, htmlServletResponse).writer(), (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement of(@NotNull CharSequence title, @NotNull Appendable response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(response, (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement of(@NotNull CharSequence title, @NotNull Appendable response, @NotNull Charset charset, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(response, (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement niceOf(@NotNull CharSequence title, @NotNull Appendable response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(response, (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement niceOf(@NotNull CharSequence title, @NotNull Appendable response, @NotNull Charset charset, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCharset(charset);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(response, (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement niceOfResponse(@NotNull String title, @NotNull Object httpServletResponse, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(RContext.ofServlet(null, httpServletResponse).writer(), (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement niceOfResponse(@NotNull Object httpServletResponse, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setCssLinks(cssLinks);
        return HtmlElement.of(RContext.ofServlet(null, httpServletResponse).writer(), (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement niceOf(@NotNull String title, @NotNull RContext context, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(context.writer(), (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement niceOf(@NotNull String title, @NotNull Appendable response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlElement.of(response, (HtmlConfig)config);
    }

    @NotNull
    public static HtmlElement of(@Nullable HtmlConfig config) throws IllegalStateException {
        return HtmlElement.of(new StringBuilder(256), config);
    }

    @NotNull
    public final ExceptionProvider then(@NotNull Consumer<HtmlElement> builder) {
        return this.next(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExceptionProvider next(@NotNull Consumer<HtmlElement> builder) {
        try {
            builder.accept(this);
            ExceptionProvider exceptionProvider = ExceptionProvider.of();
            return exceptionProvider;
        }
        catch (RuntimeException e) {
            ExceptionProvider exceptionProvider = ExceptionProvider.of(e);
            return exceptionProvider;
        }
        finally {
            this.close();
        }
    }
}

