/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.io.IOException;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.IOConsumer;
import org.ujorm.tools.web.ao.IOElement;
import org.ujorm.tools.web.ao.IORunnable;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.web.request.RContext;
import org.ujorm.tools.xml.config.HtmlConfig;

public class ReqestDispatcher {
    private static final Logger LOGGER = Logger.getLogger(ReqestDispatcher.class.getName());
    @NotNull
    private final RContext context;
    @NotNull
    private final HtmlConfig htmlConfig;
    private boolean done = false;
    private final boolean noCache = true;

    public ReqestDispatcher(@NotNull RContext context) {
        this("Info", context);
    }

    public ReqestDispatcher(@NotNull CharSequence title, @NotNull RContext context) {
        this(context, (HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public ReqestDispatcher(@NotNull RContext context, @NotNull HtmlConfig htmlConfig) {
        this.context = context;
        this.htmlConfig = htmlConfig;
    }

    @NotNull
    public HtmlConfig getAjaxConfig() {
        return this.htmlConfig.cloneForAjax();
    }

    public ReqestDispatcher onParam(@NotNull HttpParameter key, @NotNull IOConsumer<JsonBuilder> processor) throws IOException {
        Assert.notNull((Object)key, (Object[])new String[]{"Parameter {} is required", "key"});
        if (!this.done && key.of(this.context, false)) {
            try (JsonBuilder builder = JsonBuilder.of(this.context.writer(), this.getAjaxConfig());){
                this.done = true;
                processor.accept(builder);
            }
        }
        return this;
    }

    public void onDefaultToElement(@NotNull IOElement defaultProcessor) throws IOException {
        if (!this.done) {
            try (HtmlElement html = HtmlElement.of(this.context.writer(), this.htmlConfig);){
                defaultProcessor.run(html);
            }
        }
    }

    public void onDefault(@NotNull IORunnable defaultProcessor) throws IOException {
        if (!this.done) {
            defaultProcessor.run();
        }
    }
}

