/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ao;

import java.util.Locale;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.ao.DefaultHttpParam;
import org.ujorm.tools.web.request.RContext;
import org.ujorm.tools.web.request.URequest;

public interface HttpParameter
extends CharSequence {
    public static final String EMPTY_VALUE = "";

    @Override
    @NotNull
    public String toString();

    @Override
    default public int length() {
        return this.toString().length();
    }

    @Override
    default public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    default public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @NotNull
    default public String defaultValue() {
        return EMPTY_VALUE;
    }

    @NotNull
    default public String buildParameterName(@Nullable String name) {
        return name != null ? name : this.originalName().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    @NotNull
    default public String originalName() {
        try {
            return String.valueOf(this.getClass().getMethod("name", new Class[0]).invoke((Object)this, new Object[0]));
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException("Method 'name()' is not available", e);
        }
    }

    @NotNull
    default public String of(@NotNull URequest request, @NotNull String defaultValue) {
        Object[] results = request.getParameters(this.toString());
        String result = Check.hasLength((Object[])results) ? results[results.length - 1] : defaultValue;
        return result != null ? result : defaultValue;
    }

    @NotNull
    default public String of(@NotNull RContext context, @NotNull String defaultValue) {
        return this.of(context.request(), defaultValue);
    }

    @NotNull
    default public String of(@NotNull RContext context) {
        return this.of(context.request(), this.defaultValue());
    }

    @NotNull
    default public String of(@NotNull URequest request) {
        return this.of(request, this.defaultValue());
    }

    default public boolean of(@NotNull RContext context, @Nullable boolean defaultValue) {
        switch (this.of(context)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return defaultValue;
    }

    default public char of(@NotNull RContext context, @Nullable char defaultValue) {
        String value = this.of(context);
        return value.isEmpty() ? defaultValue : value.charAt(0);
    }

    default public short of(@NotNull RContext context, @Nullable short defaultValue) {
        String value = this.of(context, EMPTY_VALUE);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public int of(@NotNull RContext context, @Nullable int defaultValue) {
        String value = this.of(context, EMPTY_VALUE);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public long of(@NotNull RContext context, @Nullable long defaultValue) {
        String value = this.of(context, EMPTY_VALUE);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public float of(@NotNull RContext context, @Nullable float defaultValue) {
        String value = this.of(context, EMPTY_VALUE);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    default public double of(@NotNull RContext context, @Nullable double defaultValue) {
        String value = this.of(context, EMPTY_VALUE);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    default public <V extends Enum<V>> V of(@NotNull RContext context, @NotNull V defaultValue) {
        Object result = this.of(context, defaultValue.getClass());
        return (V)(result != null ? result : defaultValue);
    }

    @Nullable
    default public <V extends Enum<V>> V of(@NotNull RContext context, @NotNull Class<V> clazz) {
        String value = this.of(context);
        for (Enum item : (Enum[])clazz.getEnumConstants()) {
            if (!item.name().equals(value)) continue;
            return (V)item;
        }
        return null;
    }

    default public <V> V of(@NotNull RContext context, @NotNull V defaultValue, @NotNull Function<String, V> decoder) {
        String value = this.of(context, EMPTY_VALUE);
        if (value.isEmpty()) {
            return defaultValue;
        }
        try {
            return decoder.apply(value);
        }
        catch (RuntimeException e) {
            return defaultValue;
        }
    }

    public static HttpParameter of(@NotNull String name) {
        return new DefaultHttpParam(name, EMPTY_VALUE);
    }

    public static HttpParameter of(@NotNull String name, @NotNull String defaultValue) {
        return new DefaultHttpParam(name, defaultValue);
    }
}

