/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ao;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Reflections {
    public static Reader getServletReader(Object httpServletRequest) {
        return (Reader)Reflections.getAttribute(httpServletRequest, "getReader");
    }

    public static Writer getServletWriter(Object httpServletResponse) {
        return (Writer)Reflections.getAttribute(httpServletResponse, "getWriter");
    }

    public static Map<String, String[]> getParameterMap(Object httpServletRequest) {
        return (Map)Reflections.getAttribute(httpServletRequest, "getParameterMap");
    }

    public static void setCharacterEncoding(@Nullable Object httpServletRequest, @NotNull String charset) {
        String methodName = "setCharacterEncoding";
        if (httpServletRequest != null) {
            try {
                Class<?> requestClass = httpServletRequest.getClass();
                Method setCharsetEncoding = requestClass.getMethod("setCharacterEncoding", String.class);
                setCharsetEncoding.invoke(httpServletRequest, charset);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String msg = String.format("Method does not exists: %s.%s()", httpServletRequest.getClass().getSimpleName(), "setCharacterEncoding");
                throw new RuntimeException(msg, e);
            }
        }
    }

    private static Object getAttribute(Object servletRequest, String methodName) {
        try {
            Method getReaderMethod = servletRequest.getClass().getMethod(methodName, new Class[0]);
            return getReaderMethod.invoke(servletRequest, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            String msg = String.format("Method does not exists: %s.%s()", servletRequest.getClass().getSimpleName(), methodName);
            throw new RuntimeException(msg, e);
        }
    }
}

