/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.report;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ajax.JavaScriptWriter;
import org.ujorm.tools.web.ajax.ReqestDispatcher;
import org.ujorm.tools.web.ao.Column;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;
import org.ujorm.tools.web.json.JsonBuilder;
import org.ujorm.tools.web.report.ReportBuilderConfig;
import org.ujorm.tools.web.report.ReportBuilderConfigImpl;
import org.ujorm.tools.web.request.RContext;
import org.ujorm.tools.web.table.ColumnModel;
import org.ujorm.tools.web.table.Direction;
import org.ujorm.tools.web.table.GridBuilder;
import org.ujorm.tools.xml.config.HtmlConfig;

public class ReportBuilder<D> {
    private static final Logger LOGGER = Logger.getLogger(ReportBuilder.class.getName());
    private static final HttpParameter UNDEFINED_PARAM = HttpParameter.of("UNDEFINED_PARAM");
    @NotNull
    protected final GridBuilder<D> gridBuilder;
    protected final ReportBuilderConfig config;
    @NotNull
    protected HttpParameter ajaxRequestParam = JavaScriptWriter.DEFAULT_AJAX_REQUEST_PARAM;
    @NotNull
    protected Injector htmlHeader = e -> {};
    @NotNull
    protected Injector header = e -> e.addHeading(this.config.getConfig().getTitle(), new CharSequence[0]);
    @NotNull
    protected Injector footer;
    @NotNull
    protected Injector formAdditions = this.footer = e -> e.addText((Object)"");
    @NotNull
    protected Supplier<Injector> javascritWriter = () -> new JavaScriptWriter().setAjax(this.ajaxEnabled).setSubtitleSelector("." + this.config.getSubtitleCss());
    protected boolean ajaxEnabled = true;
    protected boolean autoSubmmitOnLoad = false;
    private int sortedColumn = -1;

    public ReportBuilder(@NotNull CharSequence title) {
        this((HtmlConfig)HtmlConfig.ofDefault().setTitle(title).setNiceFormat());
    }

    public ReportBuilder(@NotNull HtmlConfig config) {
        this(ReportBuilderConfig.of(config));
    }

    public ReportBuilder(@NotNull ReportBuilderConfig config) {
        this(config, new GridBuilder(config));
    }

    public ReportBuilder(@NotNull ReportBuilderConfig config, @NotNull GridBuilder<D> builder) {
        this.gridBuilder = builder;
        this.config = config;
    }

    @NotNull
    public <V> ReportBuilder<D> add(Function<D, V> column) {
        this.gridBuilder.add(column);
        return this;
    }

    @NotNull
    public <V> ReportBuilder<D> add(Function<D, V> column, CharSequence title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @NotNull
    public <V> ReportBuilder<D> add(Function<D, V> column, Injector title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @NotNull
    public <V> ReportBuilder<D> add(Function<D, V> column, CharSequence title, @Nullable HttpParameter param) {
        this.gridBuilder.add(column, title, param);
        return this;
    }

    @NotNull
    public <V> ReportBuilder<D> add(Function<D, V> column, Injector title, @Nullable HttpParameter param) {
        this.gridBuilder.add(column, title, param);
        return this;
    }

    @NotNull
    public ReportBuilder<D> addColumn(@NotNull Column<D> column, @NotNull CharSequence title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @NotNull
    public ReportBuilder<D> addColumn(@NotNull Column<D> column, @NotNull Injector title) {
        this.gridBuilder.add(column, title);
        return this;
    }

    @NotNull
    public ReportBuilder<D> addOrder(@NotNull CharSequence title) {
        this.gridBuilder.addOrder(title);
        return this;
    }

    public ColumnModel<D, ?> getColumn(int index) {
        return this.gridBuilder.getColumn(index);
    }

    public int getColumnSize() {
        return this.gridBuilder.getColumnSize();
    }

    @NotNull
    public <V> ReportBuilder<D> sortable() {
        this.gridBuilder.sortable();
        return this;
    }

    @NotNull
    public <V> ReportBuilder<D> sortable(@Nullable boolean ascending) {
        this.gridBuilder.sortable(ascending);
        return this;
    }

    @NotNull
    public <V> ReportBuilder<D> sortable(@NotNull Direction direction) {
        this.gridBuilder.sortable(direction);
        return this;
    }

    @NotNull
    public ColumnModel<D, ?> getSortedColumn() {
        return this.gridBuilder.getSortedColumn();
    }

    @NotNull
    public ReportBuilder<D> setAjaxRequestParam(@NotNull HttpParameter ajaxRequestParam) {
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        return this;
    }

    @NotNull
    public ReportBuilder<D> setHtmlHeader(@NotNull Injector htmlHeader) {
        this.htmlHeader = (Injector)Assert.notNull((Object)htmlHeader, (Object[])new String[]{"htmlHeader"});
        return this;
    }

    @NotNull
    public ReportBuilder<D> setHeader(@NotNull Injector header) {
        this.header = (Injector)Assert.notNull((Object)header, (Object[])new String[]{"header"});
        return this;
    }

    @NotNull
    public ReportBuilder<D> setFooter(@NotNull Injector footer) {
        this.footer = (Injector)Assert.notNull((Object)footer, (Object[])new String[]{"footer"});
        return this;
    }

    @NotNull
    public ReportBuilder<D> setFormItem(@NotNull Injector formItem) {
        this.formAdditions = (Injector)Assert.notNull((Object)formItem, (Object[])new String[]{"formAdditions"});
        return this;
    }

    public ReportBuilder<D> setAjaxEnabled(boolean ajaxEnabled) {
        this.ajaxEnabled = ajaxEnabled;
        return this;
    }

    public ReportBuilder<D> setJavascritWriter(@NotNull Supplier<Injector> javascritWriter) {
        this.javascritWriter = (Supplier)Assert.notNull(javascritWriter, (Object[])new String[]{"javascritWriter"});
        return this;
    }

    public ReportBuilder<D> setEmbeddedIcons(boolean embeddedIcons) throws IllegalStateException {
        if (!(this.config instanceof ReportBuilderConfigImpl)) {
            throw new IllegalStateException("Configuration must be type of: " + ReportBuilderConfigImpl.class);
        }
        ((ReportBuilderConfigImpl)this.config).setEmbeddedIcons(embeddedIcons);
        return this;
    }

    public void build(@NotNull RContext context, @NotNull Stream<D> resource) {
        this.build(context, (GridBuilder<D> tableBuilder) -> resource);
    }

    public void build(@NotNull RContext context, @NotNull Function<GridBuilder<D>, Stream<D>> resource) {
        try {
            this.setSort(ColumnModel.ofCode(this.config.getSortRequestParam().of(context)));
            new ReqestDispatcher(context, this.config.getConfig()).onParam(this.config.getAjaxRequestParam(), jsonBuilder -> this.doAjax(context, (JsonBuilder)jsonBuilder, resource)).onDefaultToElement(element -> this.printHtmlBody(context, element, resource));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Internal server error", e);
            throw new IllegalStateException("500");
        }
    }

    protected void setSort(@NotNull ColumnModel sort) {
        this.sortedColumn = sort.getIndex();
        if (this.sortedColumn >= 0) {
            int[] i = new int[]{-1};
            this.gridBuilder.getColumns().forEach(cm -> {
                i[0] = i[0] + 1;
                if (cm.isSortable()) {
                    cm.setDirection(sort.getIndex() == i[0] ? sort.getDirection() : Direction.NONE);
                }
            });
        }
    }

    protected void printHtmlBody(@NotNull RContext context, @NotNull HtmlElement html, @NotNull Function<GridBuilder<D>, Stream<D>> resource) {
        Assert.notNull((Object)context, (Object[])new String[]{"context"});
        Assert.notNull((Object)html, (Object[])new String[]{"html"});
        Assert.notNull(resource, (Object[])new String[]{"resource"});
        if (Check.hasLength((CharSequence)this.config.getJavascriptLink())) {
            html.addJavascriptLink(false, this.config.getJavascriptLink());
        }
        html.addCssLink(this.config.getCssLink());
        this.config.getCssWriter().accept(html.getHead(), this.gridBuilder.isSortable());
        this.javascritWriter.get().write(html.getHead());
        this.htmlHeader.write(html.getHead());
        try (Element body = html.getBody();){
            this.header.write(body);
            body.addDiv(this.config.getSubtitleCss()).addText((Object)(this.ajaxEnabled ? this.config.getAjaxReadyMessage() : ""));
            try (Element form = body.addForm(new CharSequence[0]).setId(this.config.getFormId()).setMethod("post").setAction("?");){
                this.gridBuilder.getColumns().forEach(column -> {
                    if (column.isFiltered()) {
                        HttpParameter param = column.getParam(UNDEFINED_PARAM);
                        form.addTextInp(param, param.of(context), column.getTitle(), this.config.getControlCss(), column.getParam(UNDEFINED_PARAM));
                    }
                });
                form.addInput(new CharSequence[0]).setType("submit").setAttribute("hidden");
                if (this.gridBuilder.isSortable()) {
                    this.printSortedField(form.addSpan(new CharSequence[0]).setId(this.config.getSortRequestParam()), context);
                }
                this.formAdditions.write(form);
                List<CharSequence> tableCss = this.config.getTableCssClass();
                this.printTableBody(form.addTable(tableCss.toArray(new CharSequence[tableCss.size()])), context, resource);
            }
            this.footer.write(body);
        }
    }

    protected void printSortedField(Element parent, RContext context) {
        int index = this.config.getSortRequestParam().of(context, -1);
        parent.addInput(new CharSequence[0]).setAttribute("type", "hidden").setNameValue(this.config.getSortRequestParam(), index);
    }

    protected void printTableBody(@NotNull Element table, @NotNull RContext context, @NotNull Function<GridBuilder<D>, Stream<D>> resource) {
        ColumnModel sortedColumn = ColumnModel.ofCode(this.config.getSortRequestParam().of(context));
        this.gridBuilder.build(table, sortedColumn, resource);
    }

    protected void doAjax(@NotNull RContext context, @NotNull JsonBuilder output, @NotNull Function<GridBuilder<D>, Stream<D>> resource) throws IOException {
        output.writeClass(this.config.getTableSelector(), e -> this.printTableBody(e, context, resource));
        output.writeClass((CharSequence)this.config.getSubtitleCss(), this.config.getAjaxReadyMessage());
        if (this.gridBuilder.isSortable()) {
            output.writeId((CharSequence)this.config.getSortRequestParam(), e -> this.printSortedField(e, context));
        }
    }

    public static class Url {
        protected static final String BOOTSTRAP_CSS = "https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css";
        protected static final String JQUERY_JS = "";
        final String bootstrapCss;

        public Url() {
            this(BOOTSTRAP_CSS, JQUERY_JS);
        }

        public Url(@NotNull String bootstrapCss, @NotNull String jQueryJs) {
            this.bootstrapCss = (String)Assert.hasLength((CharSequence)bootstrapCss, (Object[])new String[]{"bootstrapCss"});
        }
    }
}

