/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.request;

import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.web.ao.Reflections;
import org.ujorm.tools.web.request.ManyMap;
import org.ujorm.tools.web.request.URequest;
import org.ujorm.tools.web.request.URequestImpl;

public class RContext {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private final URequest uRequest;
    private final Appendable writer;

    public RContext(URequest uRequest, Appendable writer) {
        this.uRequest = uRequest;
        this.writer = writer;
    }

    public RContext(URequest uRequest) {
        this(uRequest, new StringBuilder());
    }

    public RContext() {
        this(URequestImpl.of(), new StringBuilder());
    }

    public URequest request() {
        return this.uRequest;
    }

    public Appendable writer() {
        return this.writer;
    }

    public String getParameter(@NotNull String key) {
        return this.getParameter(key, null);
    }

    public Set<String> getParameterNames() {
        return this.uRequest.getParameterNames();
    }

    public String getParameter(@NotNull String key, String defaultValue) {
        URequest uRequest = this.request();
        if (uRequest != null) {
            String[] params = uRequest.getParameters(key);
            return params.length > 0 ? params[params.length - 1] : defaultValue;
        }
        return defaultValue;
    }

    public static RContext ofServletResponse(Object httpServletResponse) {
        return RContext.ofServlet(null, httpServletResponse);
    }

    public static RContext ofServlet(@Nullable Object httpServletRequest, @NotNull Object httpServletResponse) {
        Reflections.setCharacterEncoding(httpServletResponse, CHARSET.name());
        Writer writer = Reflections.getServletWriter(httpServletResponse);
        URequest ureq = httpServletRequest != null ? URequest.ofRequest(httpServletRequest) : URequestImpl.of();
        return new RContext(ureq, writer);
    }

    public static RContext of(ManyMap map) {
        return new RContext(URequestImpl.ofMap(map), new StringBuilder());
    }

    public static RContext of() {
        return RContext.of(new ManyMap());
    }
}

