/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.request;

import java.io.Reader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.web.ao.Reflections;
import org.ujorm.tools.web.request.RContext;
import org.ujorm.tools.web.request.URequestImpl;

public interface URequest {
    public Reader getReader();

    @NotNull
    public String[] getParameters(String var1);

    @NotNull
    public Set<String> getParameterNames();

    public static URequest ofRequest(final @Nullable Object httpServletRequest) {
        Reflections.setCharacterEncoding(httpServletRequest, RContext.CHARSET.name());
        return new URequest(){
            Map<String, String[]> paramMap = null;

            @Override
            public Reader getReader() {
                return Reflections.getServletReader(httpServletRequest);
            }

            @Override
            public String[] getParameters(String key) {
                if (httpServletRequest != null) {
                    Map<String, String[]> paramMap = this.getMap(httpServletRequest);
                    String[] result = paramMap.get(key);
                    return result != null ? result : URequestImpl.emptyTexts;
                }
                return URequestImpl.emptyTexts;
            }

            @Override
            @NotNull
            public Set<String> getParameterNames() {
                return this.getMap(httpServletRequest).keySet();
            }

            @NotNull
            private Map<String, String[]> getMap(@NotNull Object httpServletRequest2) {
                if (this.paramMap == null) {
                    this.paramMap = Reflections.getParameterMap(httpServletRequest2);
                }
                return this.paramMap != null ? this.paramMap : Collections.emptyMap();
            }
        };
    }
}

