/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.table;

import java.io.IOException;
import java.util.Comparator;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.msg.MsgFormatter;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.table.Direction;

public class ColumnModel<D, V> {
    private static final NullPointerException x = null;
    private static final Pattern NUMBER = Pattern.compile("-?\\d+");
    private final int index;
    @NotNull
    private final Function<D, V> column;
    @NotNull
    private final CharSequence title;
    @Nullable
    private final HttpParameter param;
    private boolean sortable = false;
    @NotNull
    private Direction direction = Direction.NONE;

    public ColumnModel(@NotNull Direction direction, int index) {
        this(index, x -> null, "", null);
        this.setSortable(direction);
    }

    public ColumnModel(int index, @NotNull Function<D, V> column, @NotNull CharSequence title, @Nullable HttpParameter param) {
        this.index = index;
        this.column = (Function)Assert.notNull(column, (Object[])new String[]{"column"});
        this.title = (CharSequence)Assert.notNull((Object)title, (Object[])new String[]{"title"});
        this.param = param;
    }

    public int getIndex() {
        return this.index;
    }

    @NotNull
    public Function<D, V> getColumn() {
        return this.column;
    }

    @NotNull
    public CharSequence getTitle() {
        return this.title;
    }

    @Nullable
    public HttpParameter getParam() {
        return this.param;
    }

    @NotNull
    public HttpParameter getParam(@NotNull HttpParameter defaultValue) {
        return this.param != null ? this.param : defaultValue;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    @NotNull
    public Direction getDirection() {
        return this.direction;
    }

    public boolean isFiltered() {
        return this.param != null;
    }

    public final void setSortable(@NotNull Direction direction) {
        this.sortable = true;
        this.setDirection(direction);
    }

    public final void setDirection(@NotNull Direction direction) {
        this.direction = (Direction)((Object)Assert.notNull((Object)((Object)direction), (Object[])new String[]{"direction"}));
    }

    public String toCode(boolean opposite) {
        try {
            return this.toCode(opposite, new StringBuilder(4)).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Appendable toCode(boolean opposite, @NotNull Appendable writer) throws IOException {
        int coeff = Direction.ASC.safeEquals(this.direction) == opposite ? -1 : 1;
        writer.append(String.valueOf(coeff * (this.index + 1)));
        return writer;
    }

    @NotNull
    public Comparator<D> getComparator(@Nullable Function<D, ?> defaultFce) {
        return this.getComparator(Comparator.comparing(defaultFce));
    }

    @NotNull
    public Comparator<D> getComparator(@NotNull Comparator<D> defaultCompar) {
        if (this.sortable && this.isIncludeColumnType()) {
            Comparator<D> compar = Comparator.comparing(this.column);
            switch (this.direction) {
                case ASC: {
                    return compar;
                }
                case DESC: {
                    return compar.reversed();
                }
            }
        }
        return defaultCompar;
    }

    protected boolean isIncludeColumnType() {
        return true;
    }

    public String toString() {
        return MsgFormatter.format((CharSequence)"[{}]:{}:{}", (Object[])new Object[]{this.index, this.title, this.sortable ? this.direction.name() : "-"});
    }

    @NotNull
    public static ColumnModel ofCode(@NotNull String paramValue) {
        if (NUMBER.matcher(paramValue).matches()) {
            int intCode = Integer.parseInt(paramValue);
            Direction direction = Direction.of(intCode > 0);
            return new ColumnModel(direction, Math.abs(intCode) - 1);
        }
        return new ColumnModel(Direction.NONE, -1);
    }

    public static <D, V> ColumnModel<D, V> ofStub() {
        return new ColumnModel<Object, Object>(-1, x -> null, "", null);
    }
}

