/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.builder;

import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.xml.AbstractWriter;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;

public class XmlPrinter
extends AbstractWriter {
    public XmlPrinter() {
        this(new StringBuilder(512));
    }

    public XmlPrinter(@NotNull Appendable out) {
        this(out, XmlConfig.ofDefault());
    }

    public <T> XmlPrinter(@NotNull Appendable out, @Nullable XmlConfig config) {
        super(out, config);
        try {
            out.append(config.getDoctype());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeRawValue(@NotNull Object rawValue, @NotNull XmlBuilder element) throws IOException {
        this.out.append(rawValue.toString());
    }

    void writeAttrib(@NotNull String name, Object data, XmlBuilder owner) throws IOException {
        if (owner.getName() != XmlBuilder.HIDDEN_NAME) {
            this.out.append(' ');
            this.out.append(name);
            this.out.append('=');
            this.out.append('\"');
            this.writeValue(data, owner, name);
            this.out.append('\"');
        }
    }

    void writeRawText(Object rawText) throws IOException {
        this.out.append(String.valueOf(rawText));
    }

    void writeBeg(XmlBuilder element, boolean lastText) throws IOException {
        String name = element.getName();
        if (name != XmlBuilder.HIDDEN_NAME) {
            if (!lastText) {
                this.writeNewLine(element.getLevel());
            }
            this.out.append('<');
            this.out.append(name);
        }
    }

    void writeMid(XmlBuilder element) throws IOException {
        if (element.getName() != XmlBuilder.HIDDEN_NAME) {
            this.out.append('>');
        }
    }

    void writeEnd(XmlBuilder element) throws IOException {
        String name = element.getName();
        boolean pairElement = this.config.pairElement(element);
        boolean filled = element.isFilled();
        if (name != XmlBuilder.HIDDEN_NAME) {
            if (filled || pairElement) {
                if (this.indentationEnabled && !element.isLastText()) {
                    if (pairElement && !filled) {
                        this.out.append('>');
                    } else {
                        this.writeNewLine(element.getLevel());
                    }
                } else if (!filled) {
                    this.out.append('>');
                }
                this.out.append('<');
                this.out.append('/');
                this.out.append(name);
                this.out.append('>');
            } else {
                this.out.append('/');
                this.out.append('>');
            }
        }
    }

    @Override
    @NotNull
    public String toString() {
        String result = this.out.toString();
        return result != null ? result : String.valueOf(result);
    }

    public XmlBuilder createElement(@NotNull String name) throws IOException {
        return new XmlBuilder(name, this);
    }

    public static XmlPrinter forXml() {
        return XmlPrinter.forXml(null, XmlConfig.ofDefault());
    }

    public static XmlPrinter forNiceXml() {
        DefaultXmlConfig config = XmlConfig.ofDefault();
        config.setNiceFormat();
        return XmlPrinter.forXml(null, config);
    }

    public static XmlPrinter forXml(@Nullable Appendable out, @NotNull XmlConfig config) {
        return new XmlPrinter(out != null ? out : new StringBuilder(512), config);
    }

    public static XmlPrinter forHtml() {
        return XmlPrinter.forXml(null, HtmlConfig.ofDefault());
    }

    public static XmlPrinter forHtml(Appendable out) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        return XmlPrinter.forXml(out, config);
    }

    public static XmlPrinter forNiceHtml(Appendable out) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        return XmlPrinter.forHtml(out, (HtmlConfig)config);
    }

    public static XmlPrinter forHtml(@NotNull Object httpServletResponse) throws IOException {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        return XmlPrinter.forHtml(httpServletResponse, (HtmlConfig)config);
    }

    public static XmlPrinter forNiceHtml(@NotNull Object httpServletResponse) throws IOException {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        return XmlPrinter.forHtml(httpServletResponse, (HtmlConfig)config);
    }

    public static <T> XmlPrinter forHtml(@Nullable Appendable out, @NotNull HtmlConfig config) {
        return new XmlPrinter(out != null ? out : new StringBuilder(512), config);
    }

    public static XmlPrinter forHtml(@NotNull Object httpServletResponse, @NotNull Charset charset, @NotNull String indentationSpace, boolean noCache) throws IOException {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setCharset(charset);
        config.setIndentationSpace(indentationSpace);
        config.setCacheAllowed(!noCache);
        return XmlPrinter.forHtml(httpServletResponse, (HtmlConfig)config);
    }

    public static XmlPrinter forHtml(@NotNull Object httpServletResponse, @NotNull HtmlConfig config) throws IOException {
        try {
            Appendable writer = XmlPrinter.createWriter(httpServletResponse, config.getCharset(), config.isCacheAllowed());
            return new XmlPrinter(writer, config);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Response must be type of HttpServletResponse", e);
        }
    }
}

