/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.config.ApiInjector;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;

public class DefaultHtmlConfig
extends DefaultXmlConfig
implements HtmlConfig {
    @NotNull
    private CharSequence title = "Demo";
    @NotNull
    private CharSequence[] cssLinks = new CharSequence[0];
    @NotNull
    private CharSequence language = "en";
    @NotNull
    private String contentType = "text/html";
    private boolean buildDom = false;
    private boolean htmlHeaderRequest = true;
    @Deprecated
    @Nullable
    private CharSequence rawHeaderText = null;
    @NotNull
    private ApiInjector headerInjector;
    private String rootElementName;
    private Set<String> unpairElements;

    public DefaultHtmlConfig() {
        this.headerInjector = e -> {};
        this.rootElementName = "html";
        this.unpairElements = new HashSet<String>(){
            {
                this.add("area");
                this.add("base");
                this.add("br");
                this.add("col");
                this.add("embed");
                this.add("hr");
                this.add("img");
                this.add("input");
                this.add("keygen");
                this.add("link");
                this.add("meta");
                this.add("param");
                this.add("source");
                this.add("style");
                this.add("track");
            }
        };
    }

    public DefaultHtmlConfig(@NotNull HtmlConfig htmlConfig) {
        super(htmlConfig);
        this.headerInjector = e -> {};
        this.rootElementName = "html";
        this.unpairElements = new /* invalid duplicate definition of identical inner class */;
        this.title = htmlConfig.getTitle();
        this.cssLinks = htmlConfig.getCssLinks();
        this.language = htmlConfig.getLanguage().orElse(null);
        this.contentType = htmlConfig.getContentType();
        this.buildDom = htmlConfig.isDocumentObjectModel();
        this.htmlHeaderRequest = htmlConfig.isDocumentObjectModel();
        this.rawHeaderText = htmlConfig.getRawHeaderText();
        this.headerInjector = htmlConfig.getHeaderInjector();
        this.rootElementName = htmlConfig.getRootElementName();
    }

    @Override
    @NotNull
    public CharSequence getDoctype() {
        return this.nonnull(this.doctype, "<!DOCTYPE html>");
    }

    @Override
    @NotNull
    public CharSequence getTitle() {
        return this.title;
    }

    @Override
    public CharSequence[] getCssLinks() {
        return this.cssLinks;
    }

    @Override
    @NotNull
    public Optional<CharSequence> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    @Override
    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isDocumentObjectModel() {
        return this.buildDom;
    }

    @Override
    public boolean isHtmlHeaderRequest() {
        return this.htmlHeaderRequest;
    }

    @Override
    public CharSequence getRawHeaderText() {
        return this.rawHeaderText;
    }

    @Override
    @NotNull
    public ApiInjector getHeaderInjector() {
        return this.headerInjector;
    }

    @Override
    @NotNull
    public String getRootElementName() {
        return this.rootElementName;
    }

    @Override
    public Set<String> getUnpairElements() {
        return this.unpairElements;
    }

    public DefaultHtmlConfig setTitle(@NotNull CharSequence title) {
        this.title = (CharSequence)Assert.notNull((Object)title, (Object[])new String[]{"title"});
        return this;
    }

    public DefaultHtmlConfig setCssLinks(CharSequence ... cssLinks) {
        this.cssLinks = (CharSequence[])Assert.notNull((Object)cssLinks, (Object[])new String[]{"The argument {} is required", "cssLinks"});
        return this;
    }

    public DefaultHtmlConfig setLanguage(@NotNull CharSequence language) {
        this.language = language;
        return this;
    }

    public DefaultHtmlConfig setContentType(@NotNull String contentType) {
        this.contentType = (String)Assert.notNull((Object)contentType, (Object[])new String[]{"The argument {} is required", "contentType"});
        return this;
    }

    @Deprecated
    public void setDom(boolean buildDom) {
        this.setDocumentObjectModel(buildDom);
    }

    public DefaultHtmlConfig setDocumentObjectModel(boolean buildDom) {
        this.buildDom = buildDom;
        return this;
    }

    public DefaultHtmlConfig setHtmlHeader(boolean htmlHeaderRequest) {
        this.htmlHeaderRequest = htmlHeaderRequest;
        return this;
    }

    public DefaultHtmlConfig setRootElementName(@Nullable String rootElementName) {
        this.rootElementName = rootElementName != null ? rootElementName : XmlBuilder.HIDDEN_NAME;
        return this;
    }

    public void setUnpairElements(@NotNull Set<String> unpairElements) {
        this.unpairElements = (Set)Assert.notNull(unpairElements, (Object[])new String[]{"The argument {} is required", "unpairElements"});
    }

    @Deprecated
    public DefaultHtmlConfig setRawHedaderCode(@Nullable String rawHeaderText) {
        this.rawHeaderText = (CharSequence)Assert.notNull((Object)rawHeaderText, (Object[])new String[]{"The argument {} is required", "rawHeaderText"});
        return this;
    }

    public DefaultHtmlConfig setHeaderInjector(@NotNull ApiInjector headerInjector) {
        this.headerInjector = (ApiInjector)Assert.notNull((Object)headerInjector, (Object[])new String[]{"The argument {} is required", "headerInjector"});
        return this;
    }
}

