/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.model;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.AbstractWriter;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;
import org.ujorm.tools.xml.model.XmlModel;

public class XmlWriter
extends AbstractWriter {
    public XmlWriter() {
        this(new StringBuilder(512));
    }

    public XmlWriter(@NotNull Appendable out) {
        super(out, XmlConfig.ofDefault());
    }

    public XmlWriter(@NotNull Appendable out, @NotNull CharSequence indentationSpace) {
        super(out, XmlWriter.createConfig(indentationSpace));
    }

    private static XmlConfig createConfig(@NotNull CharSequence indentationSpace) {
        DefaultXmlConfig config = XmlConfig.ofDefault();
        config.setIndentationSpace(indentationSpace);
        return config;
    }

    @NotNull
    public final XmlWriter write(int level, @NotNull XmlModel element) throws IOException {
        return this.write(level, element.getName(), element.attributes, element.children, element);
    }

    @NotNull
    protected XmlWriter write(int level, @Nullable CharSequence name, @Nullable Map<String, Object> attributes, @Nullable List<Object> children, @NotNull XmlModel element) throws IOException {
        boolean validName;
        boolean bl = validName = name != XmlBuilder.HIDDEN_NAME;
        if (validName) {
            this.out.append('<');
            this.out.append(name);
            if (Check.hasLength(attributes)) {
                assert (attributes != null);
                for (String key : attributes.keySet()) {
                    this.out.append(' ');
                    this.out.append(key);
                    this.out.append('=');
                    this.out.append('\"');
                    this.writeValue(attributes.get(key), element, key);
                    this.out.append('\"');
                }
            }
        }
        if (Check.hasLength(children)) {
            assert (children != null);
            if (validName) {
                this.out.append('>');
            }
            boolean writeNewLine = validName;
            for (Object child : children) {
                if (child instanceof XmlModel) {
                    XmlModel xmlChild = (XmlModel)child;
                    if (writeNewLine && xmlChild.name != XmlBuilder.HIDDEN_NAME) {
                        this.writeNewLine(level);
                    } else {
                        writeNewLine = validName;
                    }
                    this.write(level + 1, xmlChild);
                    continue;
                }
                if (child instanceof XmlModel.RawEnvelope) {
                    this.writeRawValue(((XmlModel.RawEnvelope)child).get().toString(), element);
                    writeNewLine = false;
                    continue;
                }
                this.writeValue(child, element, null);
                writeNewLine = false;
            }
            if (this.indentationEnabled && writeNewLine && level >= 0) {
                this.writeNewLine(level - 1);
            }
            if (validName) {
                this.out.append('<');
                this.out.append('/');
                this.out.append(name);
            }
        } else if (validName) {
            this.out.append('/');
        }
        if (validName) {
            this.out.append('>');
        }
        return this;
    }
}

