/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form;

import java.io.Serializable;
import org.apache.wicket.validation.INullAcceptingValidator;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.Validator;
import org.ujorm.core.KeyRing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiValidator<T>
implements IValidator<T>,
INullAcceptingValidator<T>,
Serializable {
    public static final String PROPERTY_PREFIX = "validator.";
    private Validator<T> validator;
    private KeyRing<Ujo> key;

    public UiValidator(Validator validator, Key<Ujo, T> key) {
        this.validator = validator;
        this.key = KeyRing.of(key);
    }

    public UiValidator(Validator validator, KeyRing key) {
        this.validator = validator;
        this.key = key;
    }

    public void validate(IValidatable<T> validatable) {
        org.ujorm.validator.ValidationError error = this.validator.validate(validatable.getValue(), this.key != null ? this.key.getFirstKey() : null, null);
        if (error != null) {
            ValidationError wicketErr = new ValidationError();
            wicketErr.setMessage(error.getDefaultMessage() + " [" + error.getLocalizationKey() + "]");
            wicketErr.addKey(error.getLocalizationKey() + "." + this.key.getFirstKey().getName());
            wicketErr.addKey(error.getLocalizationKey());
            wicketErr.setVariables(error.getArguments());
            validatable.error((IValidationError)wicketErr);
        }
    }

    public Validator getValidator() {
        return this.validator;
    }
}

