/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.util.List;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.form.fields.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboField<T extends Ujo>
extends Field {
    private static final long serialVersionUID = 20130621L;
    private KeyRing<T> keys;
    private List<T> items;

    public ComboField(Key property, List<T> items, Key<T, ?> selectId, Key<T, ?> display) {
        super(property.getName(), property, null);
        this.keys = KeyRing.of((Key[])new Key[]{selectId, display});
        this.items = items;
    }

    public ComboField(String componentId, Key<?, T> property, List<T> items, Key<T, ?> selectId, Key<T, ?> display, String cssClass) {
        super(componentId, property, cssClass);
        this.keys = KeyRing.of((Key[])new Key[]{selectId, display});
        this.items = items;
    }

    @Override
    protected FormComponent createInput(String componentId, IModel model) {
        DropDownChoice result = new DropDownChoice(componentId, (IModel)new Model(), this.getItems(), new IChoiceRenderer<T>(){

            public Object getDisplayValue(T object) {
                return ComboField.this.getComboDisplayValue(object);
            }

            public String getIdValue(T object, int index) {
                return ComboField.this.getComboIdValue(object, index);
            }
        });
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        result.setRequired(this.isRequired());
        result.setNullValid(!this.isRequired());
        return result;
    }

    protected Object getComboDisplayValue(T object) {
        return this.getKeyDisplay().of(object);
    }

    protected String getComboIdValue(T object, int index) {
        return String.valueOf(this.getKeyId().of(object));
    }

    public List<T> getItems() {
        return this.items;
    }

    public final Key<T, ?> getKeyId() {
        return this.keys.get(0);
    }

    public final Key<T, ?> getKeyDisplay() {
        return this.keys.get(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends OrmUjo> ComboField<T> of(Key<?, T> property, Criterion<T> items, Key<T, ?> display) {
        OrmSessionProvider session = new OrmSessionProvider();
        try {
            Query query = session.getSession().createQuery(items);
            if (display == null) {
                display = ((ColumnWrapper)query.getColumns().get(0)).getKey();
            }
            query.setColumns(true, new Key[]{display});
            query.orderBy(display);
            ComboField<T> comboField = ComboField.of(property, query, display);
            return comboField;
        }
        finally {
            session.closeSession();
        }
    }

    public static <T extends OrmUjo> ComboField<T> of(Key<?, ?> property, Query<T> query, Key<T, ?> display) {
        Key idKey = query.getTableModel().getFirstPK().getKey();
        return new ComboField<T>(property, query.list(), idKey, display);
    }
}

