/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.tools.ChoiceRendererNullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumField<T extends Ujo, E extends Enum<E>>
extends Field {
    private static final long serialVersionUID = 20130621L;
    private static final boolean NULL_SUPPORT = false;
    private List<E> items;

    public EnumField(Key<T, E> property) {
        this(property, null);
    }

    public EnumField(Key<T, E> property, String cssClass) {
        super(property.getName(), property, null);
        this.items = Arrays.asList(property.getType().getEnumConstants());
    }

    @Override
    protected FormComponent createInput(String componentId, IModel model) {
        DropDownChoice result = new DropDownChoice(componentId, (IModel)new Model(), this.getItems());
        result.setChoiceRenderer(new ChoiceRendererNullable((Component)this));
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    protected Object getComboDisplayValue(E object) {
        return ((Enum)object).name();
    }

    protected String getComboIdValue(E object, int index) {
        return ((Enum)object).name();
    }

    public List<E> getItems() {
        return this.items;
    }
}

