/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.dialog.domestic;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Ujo;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.dialog.domestic.AbstractDialogPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDialogPane<T extends Ujo>
extends AbstractDialogPane<T> {
    private static final long serialVersionUID = 20130621L;
    private static final String ALERT_CSS = "alert-text";
    private boolean feedback;

    public MessageDialogPane(ModalWindow modalWindow, IModel<String> model) {
        super(modalWindow, new Model());
        this.repeater.add(new Component[]{new MultiLineLabel(this.repeater.newChildId(), model){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                String cssClass = MessageDialogPane.this.feedback ? "alert-text help-inline" : MessageDialogPane.ALERT_CSS;
                tag.put(CssAppender.CSS_CLASS, (CharSequence)cssClass);
            }
        }});
    }

    public void setMessage(IModel<String> message) {
        this.repeater.get(0).setDefaultModel(message);
        this.feedback = false;
    }

    @Override
    protected void setFeedback(IModel<String> message) {
        if (message != null) {
            this.setMessage(message);
            this.feedback = true;
        }
    }

    public static MessageDialogPane create(String componentId, int width, int height) {
        Model model = Model.of((Serializable)((Object)""));
        ModalWindow modalWindow = new ModalWindow(componentId, (IModel)model);
        modalWindow.setCssClassName("w_blue");
        MessageDialogPane result = new MessageDialogPane(modalWindow, (IModel<String>)model);
        modalWindow.setInitialWidth(width);
        modalWindow.setInitialHeight(height);
        return result;
    }
}

