/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedbackLabel
extends MultiLineLabel {
    private Component input;
    private IModel text = null;

    public FeedbackLabel(String id, Component input) {
        super(id);
        this.input = input;
    }

    public FeedbackLabel(String id, Component component, String text) {
        this(id, component, (IModel)new Model((Serializable)((Object)text)));
    }

    public FeedbackLabel(String id, Component input, IModel iModel) {
        super(id);
        this.input = input;
        this.text = iModel;
    }

    protected void onBeforeRender() {
        if (this.input.hasFeedbackMessage()) {
            if (this.text != null) {
                this.setDefaultModel(this.text);
            } else {
                this.setDefaultModel((IModel)new Model(this.input.getFeedbackMessages().first().getMessage()));
            }
        } else {
            this.setDefaultModel(null);
        }
        super.onBeforeRender();
    }

    public void setFeedbackMessage(IModel<String> message) {
        if (message != null) {
            this.input.getFeedbackMessages().add(new FeedbackMessage(this.input, (Serializable)message.getObject(), 0));
        } else {
            this.input.getFeedbackMessages().clear();
        }
    }

    public boolean isFeedbackMessage() {
        return !this.input.getFeedbackMessages().isEmpty();
    }
}

