/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.HeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.ujorm.CompositeKey;
import org.ujorm.Key;
import org.ujorm.core.KeyRing;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.ColumnWrapper;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.Query;
import org.ujorm.orm.Session;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.grid.KeyColumn;
import org.ujorm.wicket.component.grid.KeyColumnBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoDataProvider<T extends OrmUjo>
extends SortableDataProvider<T, Object> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_DATATABLE_ID = "datatable";
    protected Long size;
    protected IModel<Criterion<T>> criterion;
    protected KeyRing<T> model;
    private List<IColumn<T, ?>> columns = new ArrayList();
    private boolean defaultColumnSorting = true;
    private boolean fetchDatabaseColumns = true;
    private OrmSessionProvider ormSession = new OrmSessionProvider();

    public UjoDataProvider(IModel<Criterion<T>> criterion) {
        this(criterion, null);
    }

    public UjoDataProvider(IModel<Criterion<T>> criterion, Key<T, ?> defaultSort) {
        this.criterion = (IModel)Args.notNull(criterion, (String)"Criterion is mandatory");
        this.model = KeyRing.of((Class)((Criterion)criterion.getObject()).getDomain());
        if (defaultSort == null) {
            defaultSort = this.model.getFirstKey();
        }
        this.setSort(defaultSort);
    }

    public final void setSort(Key<T, ?> property) {
        super.setSort((Object)KeyRing.of(property), property.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
    }

    public Key<T, ?> getSortKey() {
        SortParam sort = this.getSort();
        if (sort != null) {
            Object property = this.getSort().getProperty();
            return property instanceof KeyRing ? ((KeyRing)property).getFirstKey().descending(!sort.isAscending()) : null;
        }
        return null;
    }

    public Iterator<T> iterator(long first, long count) {
        Args.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The argument 'count' have got limit %s but the current value is %s", (Object[])new Object[]{Integer.MAX_VALUE, count});
        Query query = this.createQuery((Criterion)this.criterion.getObject()).setLimit((int)count, first).addOrderBy(this.getSortKey());
        this.fetchDatabaseColumns(query);
        this.sortDatabaseQuery(query);
        return query.iterator();
    }

    public long size() {
        if (this.size == null) {
            this.size = this.createQuery((Criterion)this.criterion.getObject()).getCount();
        }
        return this.size;
    }

    protected Session getOrmSession() {
        return this.ormSession.getSession();
    }

    public void detach() {
        this.ormSession.closeSession();
        this.size = null;
    }

    protected Query<T> createQuery(Criterion<T> criterion) {
        return this.getOrmSession().createQuery(criterion);
    }

    public KeyRing<T> getModel() {
        return this.model;
    }

    public IModel<T> model(T object) {
        return new Model((Serializable)object);
    }

    public boolean add(IColumn<T, ?> column) {
        return this.columns.add(column);
    }

    public <V> boolean add(Key<T, V> column, CssAppender cssClass) {
        boolean result = this.add(column);
        ((KeyColumn)this.columns.get(this.columns.size() - 1)).setCssClass(cssClass.getCssClass());
        return result;
    }

    public <V> boolean add(Key<T, V> column) {
        if (column.isTypeOf(Boolean.class)) {
            return this.add((IColumn<T, ?>)KeyColumnBoolean.of(column, this.isSortingEnabled(column)));
        }
        if (column.isTypeOf(Number.class)) {
            return this.add((IColumn<T, ?>)KeyColumn.of(column, this.isSortingEnabled(column), "number"));
        }
        return this.add((IColumn<T, ?>)KeyColumn.of(column, this.isSortingEnabled(column), null));
    }

    protected boolean isSortingEnabled(Key<T, ?> column) throws IllegalArgumentException {
        return this.defaultColumnSorting && this.getOrmSession().getHandler().findColumnModel(column, false) != null;
    }

    public <S> DataTable<T, S> createDataTable(int rowsPerPage) {
        return this.createDataTable(DEFAULT_DATATABLE_ID, rowsPerPage);
    }

    public <S> DataTable<T, S> createDataTable(String id, int rowsPerPage) {
        DataTable result = new DataTable<T, S>(id, this.columns, (IDataProvider)this, rowsPerPage){

            protected Item<T> newRowItem(String id, int index, IModel<T> model) {
                return new OddEvenItem(id, index, model);
            }
        };
        result.addTopToolbar((AbstractToolbar)new AjaxNavigationToolbar(result));
        result.addTopToolbar((AbstractToolbar)new HeadersToolbar(result, (ISortStateLocator)this));
        result.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar(result));
        result.setOutputMarkupId(true);
        return result;
    }

    protected void fetchDatabaseColumns(Query<T> query) {
        if (!this.fetchDatabaseColumns) {
            return;
        }
        if (this.columns.isEmpty()) {
            return;
        }
        if (query.getTableModel().isView()) {
            return;
        }
        OrmHandler handler = query.getSession().getHandler();
        ArrayList<Object> keys = new ArrayList<Object>(query.getColumns().size() + 3);
        for (ColumnWrapper columnWrapper : query.getColumns()) {
            keys.add(columnWrapper.getKey());
        }
        for (IColumn iColumn : this.columns) {
            Key key;
            if (!(iColumn instanceof KeyColumn) || !(key = ((KeyColumn)iColumn).getKey()).isComposite() || ((CompositeKey)key).getCompositeCount() <= 1 || handler.findColumnModel(key) == null) continue;
            keys.add(key);
        }
        query.setColumns(true, keys.toArray(new Key[keys.size()]));
    }

    protected void sortDatabaseQuery(Query<T> query) {
        Key<T, ?> sortKey = this.getSortKey();
        if (sortKey != null) {
            query.addOrderBy(sortKey);
        }
    }

    public final boolean isDefaultColumnSorting() {
        return this.defaultColumnSorting;
    }

    public void setDefaultColumnSorting(boolean defaultColumnSorting) {
        this.defaultColumnSorting = defaultColumnSorting;
    }

    public final boolean isFetchDatabaseColumns() {
        return this.fetchDatabaseColumns;
    }

    public void setFetchDatabaseColumns(boolean fetchDatabaseColumns) {
        this.fetchDatabaseColumns = fetchDatabaseColumns;
    }

    public List<IColumn<T, ?>> getColumns() {
        return this.columns;
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(IModel<Criterion<T>> criterion, Key<T, ?> defaultSort) {
        return new UjoDataProvider<T>(criterion, defaultSort);
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(IModel<Criterion<T>> criterion) {
        return new UjoDataProvider<T>(criterion, null);
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(Criterion<T> criterion, Key<T, ?> defaultSort) {
        return new UjoDataProvider<T>(Model.of(criterion), defaultSort);
    }

    public static <T extends OrmUjo> UjoDataProvider<T> of(Criterion<T> criterion) {
        return new UjoDataProvider<T>(Model.of(criterion), null);
    }

    public void setCssClass(Key<T, ?> key, String cssClass) {
        for (IColumn<T, ?> iColumn : this.columns) {
            if (!(iColumn instanceof KeyColumn) || !((KeyColumn)iColumn).getKey().equals(key)) continue;
            ((KeyColumn)iColumn).setCssClass(cssClass);
            break;
        }
    }
}

