/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.form.datepicker.DatePicker;
import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.ujorm.Key;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.form.fields.DateConverter;
import org.ujorm.wicket.component.form.fields.Field;

public class DateField
extends Field {
    private static final long serialVersionUID = 20130621L;
    public static final String CSS_DATEPICKER = "datePickerComponent";

    public DateField(Key property) {
        super(property.getName(), property, null);
    }

    public DateField(String componentId, Key property, String cssClass) {
        super(componentId, property, cssClass);
    }

    protected FormComponent createInput(String componentId, IModel model) {
        DatePicker result = new DatePicker(componentId, (IModel)new Model(), this.getDatePattern(), this.createJQueryOptions());
        result.add(new Behavior[]{new CssAppender(this.getInputCssClass())});
        if (this.validator != null) {
            IValidator dateValidator = this.validator;
            result.add(dateValidator);
            this.addMaxLength((FormComponent)result);
        }
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    protected String getDatePattern() {
        return this.getString("locale.date.pattern", null, "yyyy-MM-dd");
    }

    public Object getModelValue() {
        Object result = super.getModelValue();
        return this.getKey().isTypeOf(java.sql.Date.class) ? new java.sql.Date(((Date)result).getTime()) : result;
    }

    protected String getInputCssClass() {
        return CSS_DATEPICKER;
    }

    protected Options createJQueryOptions() {
        Options options = new Options();
        options.set("dateFormat", (Serializable)((Object)("'" + new DateConverter().toJQueryUIDateFormat(this.getDatePattern()) + "'")));
        return options;
    }
}

