/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.toolbar;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.time.Duration;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmUjo;
import org.ujorm.wicket.UjoEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToolbar<U extends OrmUjo>
extends Panel {
    protected static final Duration DEFAULT_DELAY = Duration.milliseconds((long)400L);
    private IModel<Criterion<U>> criterionModel = Model.of();

    public AbstractToolbar(String id) {
        super(id);
    }

    public void onInitialize() {
        super.onInitialize();
        this.buildCriterion();
    }

    protected TextField createSearchFiled(String componentId) {
        return this.createSearchFiled(componentId, componentId);
    }

    protected TextField createSearchFiled(String componentId, String placeholderKey) {
        TextField result = new TextField(componentId, (IModel)Model.of((Serializable)((Object)"")));
        result.add(new Behavior[]{new AttributeModifier("placeholder", (IModel)new ResourceModel(placeholderKey, placeholderKey))});
        result.setOutputMarkupId(true);
        result.add(new Behavior[]{this.createChangeBehavior((FormComponent)result)});
        return result;
    }

    public IModel<Criterion<U>> getCriterion() {
        return this.criterionModel;
    }

    protected abstract void buildCriterion();

    protected AjaxEventBehavior createChangeBehavior(FormComponent field) {
        return new AjaxFormComponentUpdatingBehavior("keyup"){

            protected void onUpdate(AjaxRequestTarget target) {
                AbstractToolbar.this.buildCriterion();
                AbstractToolbar.this.send((IEventSink)AbstractToolbar.this.getPage(), Broadcast.BREADTH, new UjoEvent(AbstractToolbar.this.getDefaultActionName(), target));
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setThrottlingSettings(new ThrottlingSettings("thrId", DEFAULT_DELAY, true));
            }
        };
    }

    public String getDefaultActionName() {
        return "FILTER";
    }
}

