/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.SimpleFormComponentLabel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.validation.IValidator;
import org.ujorm.Key;
import org.ujorm.Validator;
import org.ujorm.core.KeyRing;
import org.ujorm.validator.ValidatorUtils;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.form.FeedbackLabel;
import org.ujorm.wicket.component.form.FieldEvent;
import org.ujorm.wicket.component.form.UiValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends Panel {
    private static final long serialVersionUID = 20130621L;
    protected static final Duration DEFAULT_DELAY = Duration.milliseconds((long)300L);
    public static final String CSS_REQUIRED = "required";
    public static final String PROPERTY_PREFIX = "label.";
    private FormComponent input;
    protected FeedbackLabel feedback;
    protected IValidator<?> validator;
    protected String cssClass;
    protected KeyRing key;
    protected List<Behavior> behaviors;

    public Field(Key property) {
        this(property.getName(), property, null);
        this.setOutputMarkupPlaceholderTag(true);
    }

    public Field(String componentId, Key property, String cssClass) {
        super(componentId, (IModel)Model.of());
        this.key = KeyRing.of((Key)property);
        this.cssClass = cssClass;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{new CssAppender(this.getCssClass())});
        if (this.cssClass != null) {
            this.add(new Behavior[]{new CssAppender(this.cssClass)});
        }
        Component[] componentArray = new Component[1];
        this.input = this.createInput("input", this.getDefaultModel());
        componentArray[0] = this.input;
        this.add(componentArray);
        this.add(new Component[]{this.createLabel((Component)this.input)});
        Component[] componentArray2 = new Component[1];
        this.feedback = new FeedbackLabel("message", (Component)this.input, (IModel)null);
        componentArray2[0] = this.feedback;
        this.add(componentArray2);
        if (this.behaviors != null) {
            for (Behavior behavior : this.behaviors) {
                this.input.add(new Behavior[]{behavior});
            }
            this.behaviors = null;
        }
        this.feedback.setOutputMarkupId(true);
    }

    protected FormComponent createInput(String componentId, IModel model) {
        TextField result = new TextField(componentId, model, this.key.getFirstKey().getType());
        if (this.validator != null) {
            result.add(this.validator);
            this.addMaxLength((FormComponent)result);
        }
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    public IValidator<?> getValidator() {
        return this.validator;
    }

    public Field setValidator(IValidator<?> validator) {
        this.validator = validator;
        return this;
    }

    public Field setValidator(Validator<?> validator) {
        this.validator = new UiValidator(validator, this.key);
        return this;
    }

    public Object getModelValue() {
        return this.input.getDefaultModelObject();
    }

    public void setModelValue(Object value) {
        this.input.getFeedbackMessages().clear();
        this.input.setDefaultModelObject(value);
    }

    public void addBehaviour(AjaxEventBehavior behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<Behavior>();
        }
        this.behaviors.add((Behavior)behavior);
    }

    public FormComponent getInput() {
        return this.input;
    }

    protected void addMaxLength(FormComponent result) {
        int length;
        if (this.validator instanceof UiValidator && this.key.getFirstKey().isTypeOf(String.class) && (length = ValidatorUtils.getMaxLength((Validator)((UiValidator)this.validator).getValidator())) >= 0) {
            result.add(new Behavior[]{new AttributeModifier("maxlength", (IModel)Model.of((Serializable)Integer.valueOf(length)))});
        }
    }

    protected Component createLabel(Component inp) {
        SimpleFormComponentLabel result = new SimpleFormComponentLabel("label", (LabeledWebMarkupContainer)this.input);
        if (this.isRequired()) {
            result.add(new Behavior[]{new CssAppender(CSS_REQUIRED)});
        }
        return result;
    }

    protected IModel createLabelModel() {
        Key nativeKey = this.key.getFirstKey();
        ResourceModel labelModel = new ResourceModel(this.getResourceLabelKey(nativeKey), nativeKey.getName());
        return labelModel;
    }

    protected String getResourceLabelKey(Key<?, ?> key) {
        return PROPERTY_PREFIX + key.toStringFull();
    }

    protected boolean isRequired() {
        boolean result = this.validator instanceof UiValidator && ValidatorUtils.isMandatoryValidator((Validator)((UiValidator)this.validator).getValidator());
        return result;
    }

    public Key<?, ?> getKey() {
        return this.key.getFirstKey();
    }

    public void setFeedbackMessage(IModel<String> message) {
        this.feedback.setFeedbackMessage(message);
    }

    protected String getCssClass() {
        return "control-group";
    }

    public void onChange(String action) {
        this.addBehaviour(this.createChangeBehaviour(action, "keyup"));
        this.addBehaviour(this.createChangeBehaviour(action, "onchange"));
    }

    protected AjaxEventBehavior createChangeBehaviour(final String action, String jsEvent) {
        return new AjaxFormComponentUpdatingBehavior(jsEvent){

            protected void onUpdate(AjaxRequestTarget target) {
                Field.this.send((IEventSink)Field.this, Broadcast.BUBBLE, new FieldEvent(action, Field.this.key, target));
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setThrottlingSettings(new ThrottlingSettings("thr2Id", DEFAULT_DELAY, true));
            }
        };
    }
}

