/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form;

import java.io.Serializable;
import java.sql.Date;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.validation.IValidator;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.ListKey;
import org.ujorm.Ujo;
import org.ujorm.Validator;
import org.ujorm.core.UjoManager;
import org.ujorm.criterion.Criterion;
import org.ujorm.orm.OrmHandler;
import org.ujorm.orm.OrmHandlerProvider;
import org.ujorm.orm.OrmUjo;
import org.ujorm.orm.metaModel.MetaColumn;
import org.ujorm.validator.ValidatorUtils;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.OrmSessionProvider;
import org.ujorm.wicket.component.form.UiValidator;
import org.ujorm.wicket.component.form.fields.BooleanField;
import org.ujorm.wicket.component.form.fields.ComboField;
import org.ujorm.wicket.component.form.fields.DateField;
import org.ujorm.wicket.component.form.fields.EnumField;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.form.fields.GridField;
import org.ujorm.wicket.component.form.fields.PasswordField;
import org.ujorm.wicket.component.form.fields.TextAreaField;
import org.ujorm.wicket.component.form.fields.TextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldProvider<U extends Ujo>
implements Serializable {
    public static final String PASSWORD_KEY_NAME = "PASSWORD";
    private RepeatingView repeatingView;
    private Map<String, Field> fields;
    private U domain;
    private transient OrmHandler ormHandler;

    public FieldProvider(String repeatingViewId) {
        this(new RepeatingView(repeatingViewId));
    }

    public FieldProvider(RepeatingView repeatingView) {
        this(repeatingView, new LinkedHashMap<String, Field>(16));
    }

    public FieldProvider(RepeatingView repeatingView, Map<String, Field> fields) {
        this.repeatingView = repeatingView;
        this.fields = fields;
    }

    public void add(Field field) {
        Key<?, ?> key = field.getKey();
        Field oldField = this.fields.put(key.getName(), field);
        if (oldField != null) {
            throw new IllegalStateException("Field is assigned for the key: " + (Object)((Object)field));
        }
        this.repeatingView.add(new Component[]{field});
        this.addValidator(key, field);
    }

    public <T> void add(Key<U, T> key) {
        int length;
        Field field = key.isTypeOf(Boolean.class) ? new BooleanField<T>(key) : (key.isTypeOf(String.class) ? (this.isPasswordKey(key) ? new PasswordField<T>(key) : ((length = ValidatorUtils.getMaxLength((Validator)key.getValidator())) >= this.getTextAreaLimit() ? new TextAreaField<T>(key) : new TextField<T>(key))) : (key.isTypeOf(Enum.class) ? new EnumField<T>(key, "combo") : (key.isTypeOf(Enum.class) ? new EnumField<T>(key, "combo") : (key.isTypeOf(Date.class) ? new DateField<T>(key) : (key.isTypeOf(java.util.Date.class) ? new DateField<T>(key) : (key instanceof ListKey && Ujo.class.isAssignableFrom(((ListKey)key).getItemType()) ? new GridField<T>(key) : new Field<T>(key)))))));
        this.add(field);
    }

    public void add(Class<U> domainClass) {
        try {
            this.add(((Ujo)domainClass.newInstance()).readKeys());
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't get keys of the domain " + domainClass, e);
        }
    }

    public void add(KeyList<? super U> fields) {
        for (Key key : fields) {
            this.add(key);
        }
    }

    public <T extends Ujo> void add(Key<U, T> key, Class<? extends Field> fieldClass) {
        try {
            this.add(fieldClass.getConstructor(Key.class).newInstance(key));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create instance of the " + fieldClass, ex);
        }
    }

    public <T extends OrmUjo> void add(Key<U, T> key, Key<T, ?> display, Criterion<T> crn) {
        this.add(ComboField.of(key, crn, display));
    }

    public <T> T getValue(Key<U, T> key) {
        Field filed = this.fields.get(key.getName());
        return (T)(filed != null ? filed.getModelValue() : key.getDefault());
    }

    public <T> void setValue(Key<U, T> key, T value) {
        this.fields.get(key.getName()).setModelValue(value);
    }

    public <T> void setValue(Key<U, T> key, T value, AjaxRequestTarget target) {
        this.setValue(key, value);
        target.add(new Component[]{(Component)this.fields.get(key.getName())});
    }

    public Collection<Field> getFields() {
        return this.fields.values();
    }

    public <F extends Field> F getField(Key<? super U, ?> key) {
        return (F)((Object)this.fields.get(key.getName()));
    }

    public <T extends Field> T getLast() throws ArrayIndexOutOfBoundsException {
        return (T)((Object)((Field)this.repeatingView.get(this.repeatingView.size() - 1)));
    }

    protected Set<String> getKeyNames() {
        return this.fields.keySet();
    }

    public RepeatingView getRepeatingView() {
        return this.repeatingView;
    }

    protected OrmHandler getOrmHandler() {
        Application appl;
        if (this.ormHandler != null && (appl = this.repeatingView.getPage().getApplication()) instanceof OrmHandlerProvider) {
            this.ormHandler = ((OrmHandlerProvider)appl).getOrmHandler();
        }
        return this.ormHandler;
    }

    protected boolean isMandatory(Key<U, ?> key) {
        MetaColumn column;
        OrmHandler handler = this.getOrmHandler();
        if (handler != null && (column = (MetaColumn)handler.findColumnModel(key, false)).isMandatory()) {
            return true;
        }
        return ValidatorUtils.isMandatoryValidator((Validator)key.getValidator());
    }

    protected void addValidator(Key<U, ?> key, Field field) {
        FormComponent input;
        Validator validator = key.getValidator();
        if (validator != null) {
            field.addValidator(new UiValidator(validator, key));
        } else if (this.isMandatory(key) && (input = field.getInput()) instanceof FormComponent) {
            input.setRequired(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDomain(U domain) {
        OrmSessionProvider session = new OrmSessionProvider();
        try {
            this.domain = this.copyToFields(this.cloneDomain(domain, session));
        }
        finally {
            session.closeSession();
        }
    }

    protected U cloneDomain(U domain, OrmSessionProvider session) throws NoSuchElementException, IllegalStateException {
        Ujo result = domain instanceof OrmUjo ? session.getSession().loadBy((OrmUjo)domain) : UjoManager.clone(domain, (int)2, (Object)"clone");
        return (U)(result != null ? result : domain);
    }

    protected U copyToFields(U domain) {
        Args.notNull(domain, (String)"domain");
        for (Field field : this.getFields()) {
            Key<?, ?> k = field.getKey();
            field.setModelValue(k.of(domain));
        }
        return domain;
    }

    public U getDomain() {
        for (Field field : this.fields.values()) {
            Object newValue;
            Key<?, ?> k = field.getKey();
            if (!k.equals(this.domain, newValue = this.getValue(k))) {
                k.setValue(this.domain, newValue);
                continue;
            }
            if (k.getValidator() == null) continue;
            k.getValidator().checkValue(newValue, k, this.domain);
        }
        return this.domain;
    }

    public U getInputDomain() {
        return this.domain;
    }

    public int getTextAreaLimit() {
        return 180;
    }

    protected boolean isPasswordKey(Key<U, ?> key) {
        return key.getName().endsWith(PASSWORD_KEY_NAME) && (key.length() == PASSWORD_KEY_NAME.length() || key.charAt(key.length() - PASSWORD_KEY_NAME.length() - 1) == '.');
    }

    public void onChange(Key<U, ?> source) {
        this.onChange(source, "");
    }

    public void onChange(Key<U, ?> source, String action) {
        ((Field)((Object)this.getField(source))).onChange(action);
    }

    public <T> void setEnabled(Key<U, T> key, boolean enabled) {
        Object field = this.getField(key);
        if (field != null) {
            field.setEnabled(enabled);
        }
    }

    public void setVisible(Key<U, ?> key, boolean visible) {
        Object field = this.getField(key);
        if (field != null) {
            field.setVisibilityAllowed(visible);
        }
    }

    public <T> void addValidator(Key<U, T> key, Validator<T> validator) {
        Object field = this.getField(key);
        if (field != null) {
            ((Field)((Object)field)).addValidator(validator);
        }
    }

    public <T> void addValidatorUnchecked(Key<U, T> key, Validator validator) {
        this.addValidator(key, validator);
    }

    public <T> void addValidator(Key<U, T> key, IValidator<T> validator) {
        Object field = this.getField(key);
        if (field != null) {
            ((Field)((Object)field)).addValidator(validator);
        }
    }

    public <T> void addCssStyle(Key<U, T> key, String cssStyle) {
        Object field = this.getField(key);
        if (field != null) {
            field.add(new Behavior[]{new CssAppender(cssStyle)});
        }
    }
}

