/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxNavigationToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.HeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NoRecordsToolbar;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.ujorm.Key;
import org.ujorm.KeyList;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.criterion.Criterion;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.grid.KeyColumn;
import org.ujorm.wicket.component.grid.KeyColumnBoolean;
import org.ujorm.wicket.component.toolbar.InsertToolbar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataProvider<U extends Ujo>
extends SortableDataProvider<U, Object> {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_DATATABLE_ID = "datatable";
    protected static final String DEFAULT_CSS_SELECTED = "selected";
    protected Long size;
    protected IModel<Criterion<U>> filter;
    protected IModel<Criterion<U>> selected;
    private List<IColumn<U, ?>> columns = new ArrayList();
    private boolean defaultColumnSorting = true;

    public AbstractDataProvider(@Nonnull IModel<Criterion<U>> criterion) {
        this(criterion, null);
    }

    public AbstractDataProvider(@Nonnull IModel<Criterion<U>> filter, @Nullable Key<U, ?> defaultSort) {
        this.filter = (IModel)Args.notNull(filter, (String)"The filter is required");
        if (defaultSort == null) {
            KeyRing keys = KeyRing.of((Class)((Criterion)filter.getObject()).getDomain());
            defaultSort = keys.getFirstKey();
        }
        this.setSort(defaultSort);
    }

    public final void setSort(Key<U, ?> key) {
        super.setSort((Object)KeyRing.of(key), key.isAscending() ? SortOrder.ASCENDING : SortOrder.DESCENDING);
    }

    public Key<U, ?> getSortKey() {
        SortParam sort = this.getSort();
        if (sort != null) {
            Object key = this.getSort().getProperty();
            return key instanceof KeyRing ? ((KeyRing)key).getFirstKey().descending(!sort.isAscending()) : null;
        }
        return null;
    }

    public abstract Iterator<U> iterator(long var1, long var3);

    public abstract long size();

    public abstract void detach();

    public Class<U> getDomainClass() {
        return ((Criterion)this.filter.getObject()).getDomain();
    }

    public IModel<U> model(U object) {
        return new Model((Serializable)object);
    }

    public boolean add(IColumn<U, ?> column) {
        return this.columns.add(column);
    }

    public void add(KeyList<? super U> columns) {
        for (Key t : columns) {
            this.add(t);
        }
    }

    public <V> boolean add(Key<U, V> column, CssAppender cssClass) {
        boolean result = this.add(column);
        ((KeyColumn)this.columns.get(this.columns.size() - 1)).setCssClass(cssClass.getCssClass());
        return result;
    }

    public <V> boolean add(Key<U, V> column) {
        if (column.isTypeOf(Boolean.class)) {
            return this.add((IColumn<U, ?>)KeyColumnBoolean.of(column, this.isSortingEnabled(column)));
        }
        if (column.isTypeOf(Number.class)) {
            return this.add((IColumn<U, ?>)KeyColumn.of(column, this.isSortingEnabled(column), "number"));
        }
        return this.add((IColumn<U, ?>)KeyColumn.of(column, this.isSortingEnabled(column), null));
    }

    protected String getCssSelected() {
        return DEFAULT_CSS_SELECTED;
    }

    protected boolean isSortingEnabled(Key<U, ?> column) throws IllegalArgumentException {
        return this.defaultColumnSorting;
    }

    public final <S> DataTable<U, S> createDataTable(int rowsPerPage) {
        return this.createDataTable(DEFAULT_DATATABLE_ID, rowsPerPage);
    }

    public final <S> DataTable<U, S> createDataTable(String id, int rowsPerPage) {
        return this.createDataTable(id, rowsPerPage, false);
    }

    public final <S> DataTable<U, S> createDataTable(int rowsPerPage, boolean insertToolbar) {
        return this.createDataTable(DEFAULT_DATATABLE_ID, rowsPerPage, insertToolbar);
    }

    public <S> DataTable<U, S> createDataTable(String id, int rowsPerPage, boolean insertToolbar) {
        DataTable result = new DataTable<U, S>(id, this.columns, (IDataProvider)this, rowsPerPage){

            protected Item<U> newRowItem(String id, int index, IModel<U> model) {
                Criterion crn;
                OddEvenItem result = new OddEvenItem(id, index, model);
                if (AbstractDataProvider.this.selected != null && (crn = (Criterion)AbstractDataProvider.this.selected.getObject()) != null && crn.evaluate((Ujo)model.getObject())) {
                    result.add(new Behavior[]{new CssAppender(AbstractDataProvider.this.getCssSelected())});
                }
                return result;
            }
        };
        result.addTopToolbar((AbstractToolbar)new AjaxNavigationToolbar(result));
        result.addTopToolbar((AbstractToolbar)new HeadersToolbar(result, (ISortStateLocator)this));
        result.addBottomToolbar((AbstractToolbar)new NoRecordsToolbar(result));
        result.setOutputMarkupId(true);
        if (insertToolbar) {
            result.addBottomToolbar(new InsertToolbar<U>(result, this.getDomainClass()));
        }
        return result;
    }

    public final boolean isDefaultColumnSorting() {
        return this.defaultColumnSorting;
    }

    public void setDefaultColumnSorting(boolean defaultColumnSorting) {
        this.defaultColumnSorting = defaultColumnSorting;
    }

    public List<IColumn<U, ?>> getColumns() {
        return this.columns;
    }

    public void setCssClass(Key<U, ?> key, String cssClass) {
        for (IColumn<U, ?> iColumn : this.columns) {
            if (!(iColumn instanceof KeyColumn) || !((KeyColumn)iColumn).getKey().equals(key)) continue;
            ((KeyColumn)iColumn).setCssClass(cssClass);
            break;
        }
    }

    @Nullable
    public IModel<Criterion<U>> getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable IModel<Criterion<U>> selected) {
        this.selected = selected;
    }

    public void setSelected(@Nonnull Criterion<U> selected) {
        this.setSelected((IModel<Criterion<U>>)Model.of(selected));
    }

    public boolean insertRow(U row) {
        throw new UnsupportedOperationException();
    }

    public long deleteRow(Criterion<U> deleteCondition) {
        throw new UnsupportedOperationException();
    }

    public long updateRow(Criterion<U> updateCondition, U updatedRow) {
        throw new UnsupportedOperationException();
    }
}

