/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.UjoComparator;
import org.ujorm.core.UjoIterator;
import org.ujorm.criterion.Criterion;
import org.ujorm.wicket.component.grid.AbstractDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListDataProvider<T extends Ujo>
extends AbstractDataProvider<T> {
    private static final long serialVersionUID = 1L;
    private List<T> dataRows;
    private List<T> filteredRows;
    private boolean sortRequest;

    public ListDataProvider(IModel<Criterion<T>> criterion) {
        this(criterion, (Key<T, ?>)null);
    }

    public ListDataProvider(IModel<Criterion<T>> filter, Key<T, ?> defaultSort) {
        super(filter, defaultSort);
        this.sortRequest = defaultSort != null;
    }

    public void setRows(List<T> dataRows) {
        this.dataRows = dataRows;
        this.filteredRows = null;
        this.size = null;
    }

    public List<T> getRows() {
        return this.dataRows;
    }

    protected List<T> getFileredRows() {
        if (this.filteredRows == null) {
            this.filteredRows = ((Criterion)this.filter.getObject()).evaluate(this.dataRows);
        }
        return this.filteredRows;
    }

    @Override
    public Iterator<T> iterator(long first, long count) {
        Args.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The argument '%s' have got limit %s but the current value is %s", (Object[])new Object[]{"first", Integer.MAX_VALUE, first});
        Args.isTrue((count <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"The argument '%s' have got limit %s but the current value is %s", (Object[])new Object[]{"count", Integer.MAX_VALUE, count});
        List<T> rows = this.getFileredRows();
        if (this.sortRequest) {
            UjoComparator.of(this.getSortKey()).sort(rows);
        }
        int last = (int)Math.min(first + count, (long)rows.size());
        int frst = (int)Math.min(first, (long)last);
        return UjoIterator.of(rows.subList(frst, last));
    }

    @Override
    public long size() {
        if (this.size == null) {
            this.size = this.getFileredRows().size();
        }
        return this.size;
    }

    @Override
    public void detach() {
        this.clearBuffer();
    }

    protected void clearBuffer() {
        this.filteredRows = null;
        this.size = null;
    }

    @Override
    public boolean insertRow(@Nonnull T row) {
        this.clearBuffer();
        return this.getRows().add(row);
    }

    @Override
    public long deleteRow(@Nonnull Criterion<T> deleteCondition) {
        long result = 0L;
        List<T> rows = this.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            Ujo row = (Ujo)rows.get(i);
            if (!deleteCondition.evaluate(row)) continue;
            rows.remove(i);
            ++result;
        }
        this.clearBuffer();
        return result;
    }

    @Override
    public long updateRow(@Nonnull Criterion<T> updateCondition, @Nonnull T updatedRow) {
        long result = 0L;
        List<T> rows = this.getRows();
        for (int i = rows.size() - 1; i >= 0; --i) {
            Ujo row = (Ujo)rows.get(i);
            if (!updateCondition.evaluate(row)) continue;
            rows.set(i, updatedRow);
            ++result;
        }
        this.clearBuffer();
        return result;
    }

    public static <T extends Ujo> ListDataProvider<T> of(IModel<Criterion<T>> criterion, Key<T, ?> defaultSort) {
        return new ListDataProvider<T>(criterion, defaultSort);
    }

    public static <T extends Ujo> ListDataProvider<T> of(IModel<Criterion<T>> criterion) {
        return new ListDataProvider<T>(criterion, null);
    }

    public static <T extends Ujo> ListDataProvider<T> of(Criterion<T> criterion, Key<T, ?> defaultSort) {
        return new ListDataProvider<T>(Model.of(criterion), defaultSort);
    }

    public static <T extends Ujo> ListDataProvider<T> of(Criterion<T> criterion) {
        return new ListDataProvider<T>(Model.of(criterion), null);
    }
}

