/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.form.fields;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.wicket.component.form.fields.Field;
import org.ujorm.wicket.component.tools.ChoiceRendererNullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumField<T extends Enum<T>>
extends Field<T> {
    private static final long serialVersionUID = 20130621L;
    private static final boolean NULL_SUPPORT = false;
    private List<T> items;

    public <U extends Ujo> EnumField(Key<U, T> key) {
        this(key, null);
    }

    public <U extends Ujo> EnumField(Key<U, T> key, String cssClass) {
        super(key.getName(), key, null);
        this.items = Arrays.asList(key.getType().getEnumConstants());
    }

    @Override
    protected FormComponent createInput(String componentId, IModel<T> model) {
        DropDownChoice result = new DropDownChoice(componentId, (IModel)new Model(), this.getItems());
        result.setChoiceRenderer(new ChoiceRendererNullable((Component)this));
        result.setEnabled(this.isEnabled());
        result.setLabel(this.createLabelModel());
        return result;
    }

    protected Object getComboDisplayValue(T object) {
        return ((Enum)object).name();
    }

    protected String getComboIdValue(T object, int index) {
        return ((Enum)object).name();
    }

    public List<T> getItems() {
        return this.items;
    }
}

