/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.wicket.KeyModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyColumn<UJO extends Ujo, T>
extends AbstractColumn<UJO, KeyRing<UJO>> {
    private static final long serialVersionUID = 1L;
    public static final boolean SORTING_ON = true;
    public static final boolean SORTING_OFF = false;
    public static final String PROPERTY_PREFIX = "column.";
    protected final KeyRing<UJO> keySerializable;
    protected String cssClass;

    public KeyColumn(KeyRing<UJO> key, KeyRing<UJO> sortKey) {
        this((IModel<String>)new ResourceModel(PROPERTY_PREFIX + key.getFirstKey().toStringFull(), key.getFirstKey().toString()), key, sortKey);
    }

    public KeyColumn(IModel<String> label, KeyRing<UJO> key, KeyRing<UJO> sortKey) {
        super(label, sortKey);
        this.keySerializable = key;
    }

    public void populateItem(Item<ICellPopulator<UJO>> item, String componentId, IModel<UJO> rowModel) {
        Ujo ujo = (Ujo)rowModel.getObject();
        IModel<?> valueModel = this.createValueModel(ujo);
        Component value = this.createValueCoponent(componentId, valueModel, ujo);
        this.appendCssClass(value, ujo);
        item.add(new Component[]{value});
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    protected Component createValueCoponent(String componentId, IModel<?> valueModel, UJO ujo) {
        return new Label(componentId, valueModel);
    }

    protected IModel<?> createValueModel(UJO ujo) {
        KeyModel result = KeyModel.of(ujo, this.keySerializable.getFirstKey());
        return result;
    }

    public String getPropertyExpression() {
        return this.keySerializable.toString();
    }

    public Key<UJO, T> getKey() {
        return this.keySerializable.getFirstKey();
    }

    protected void appendCssClass(Component value, UJO ujo) {
    }

    public String toString() {
        return this.keySerializable.getFirstKey().toStringFull();
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted) {
        return KeyColumn.of(key, sorted, null);
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssClass) {
        KeyRing serializableKey = KeyRing.of(key);
        KeyColumn result = new KeyColumn(serializableKey, sorted ? serializableKey : null);
        result.setCssClass(cssClass);
        return result;
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, Key<U, T> sort, String cssClass) {
        KeyColumn result = new KeyColumn(KeyRing.of(key), KeyRing.of(sort));
        result.setCssClass(cssClass);
        return result;
    }
}

