/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.wicket.component.grid;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.ujorm.Key;
import org.ujorm.Ujo;
import org.ujorm.core.KeyRing;
import org.ujorm.wicket.CssAppender;
import org.ujorm.wicket.component.grid.KeyColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyColumnBoolean<UJO extends Ujo>
extends KeyColumn<UJO, Boolean> {
    private static final long serialVersionUID = 1L;
    protected static String DEFAULT_LOGICAL_CLASS = "logical";
    protected static String DEFAULT_CSS_OK_CLASS = "ok";
    protected final String cssOkClass;

    public KeyColumnBoolean(Key<UJO, ?> key, Key<UJO, ?> keySortable, String cssClass) {
        this(KeyRing.of(key), KeyRing.of(keySortable), cssClass, DEFAULT_CSS_OK_CLASS);
    }

    public KeyColumnBoolean(KeyRing<UJO> key, KeyRing<UJO> keySortable, String cssClass, String cssOkClass) {
        super(key, keySortable);
        this.setCssClass(cssClass);
        this.cssOkClass = cssOkClass;
    }

    @Override
    protected IModel<?> createValueModel(UJO ujo) {
        Object value = this.keySerializable.getFirstValue(ujo);
        String result = value == null ? "" : (Boolean.TRUE.equals(value) ? "ok" : "-");
        return Model.of((Serializable)((Object)result));
    }

    @Override
    protected void appendCssClass(Component value, UJO ujo) {
        super.appendCssClass(value, ujo);
        if (this.cssOkClass != null && Boolean.TRUE.equals(this.keySerializable.getFirstValue(ujo))) {
            value.add(new Behavior[]{new CssAppender(this.cssOkClass)});
        }
    }

    public String getCssOkClass() {
        return this.cssOkClass;
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted) {
        return KeyColumnBoolean.of(key, sorted, DEFAULT_CSS_OK_CLASS);
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, boolean sorted, String cssOkClass) {
        KeyRing serializableKey = KeyRing.of(key);
        return new KeyColumnBoolean(serializableKey, sorted ? serializableKey : null, DEFAULT_LOGICAL_CLASS, cssOkClass);
    }

    public static <U extends Ujo, T> KeyColumn<U, T> of(Key<U, T> key, Key<U, T> sort, String cssOkClass) {
        return new KeyColumnBoolean(KeyRing.of(key), KeyRing.of(sort), DEFAULT_LOGICAL_CLASS, cssOkClass);
    }
}

